/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.associations.AssociationsDrillDownStream;
import org.apache.lucene.facet.associations.AssociationsListBuilder;
import org.apache.lucene.facet.associations.CategoryAssociationsContainer;
import org.apache.lucene.facet.index.CountingListBuilder;
import org.apache.lucene.facet.index.DrillDownStream;
import org.apache.lucene.facet.index.FacetFields;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class AssociationsFacetFields
extends FacetFields {
    private static final FieldType DRILL_DOWN_TYPE = new FieldType(TextField.TYPE_NOT_STORED);

    public AssociationsFacetFields(TaxonomyWriter taxonomyWriter) {
        super(taxonomyWriter);
    }

    public AssociationsFacetFields(TaxonomyWriter taxonomyWriter, FacetIndexingParams params) {
        super(taxonomyWriter, params);
    }

    @Override
    protected Map<CategoryListParams, Iterable<CategoryPath>> createCategoryListMapping(Iterable<CategoryPath> categories) {
        CategoryAssociationsContainer categoryAssociations = (CategoryAssociationsContainer)categories;
        HashMap<CategoryListParams, Iterable<CategoryPath>> categoryLists = new HashMap<CategoryListParams, Iterable<CategoryPath>>();
        for (CategoryPath cp : categories) {
            CategoryListParams clp = this.indexingParams.getCategoryListParams(cp);
            CategoryAssociationsContainer clpContainer = (CategoryAssociationsContainer)categoryLists.get(clp);
            if (clpContainer == null) {
                clpContainer = new CategoryAssociationsContainer();
                categoryLists.put(clp, clpContainer);
            }
            clpContainer.setAssociation(cp, categoryAssociations.getAssociation(cp));
        }
        return categoryLists;
    }

    @Override
    protected Map<String, BytesRef> getCategoryListData(CategoryListParams categoryListParams, IntsRef ordinals, Iterable<CategoryPath> categories) throws IOException {
        AssociationsListBuilder associations = new AssociationsListBuilder((CategoryAssociationsContainer)categories);
        CountingListBuilder counting = new CountingListBuilder(categoryListParams, this.indexingParams, this.taxonomyWriter);
        Map<String, BytesRef> res = associations.build(ordinals, categories);
        res.putAll(counting.build(ordinals, categories));
        return res;
    }

    @Override
    protected DrillDownStream getDrillDownStream(Iterable<CategoryPath> categories) {
        return new AssociationsDrillDownStream((CategoryAssociationsContainer)categories, this.indexingParams);
    }

    @Override
    protected FieldType fieldType() {
        return DRILL_DOWN_TYPE;
    }

    @Override
    public void addFields(Document doc, Iterable<CategoryPath> categories) throws IOException {
        if (!(categories instanceof CategoryAssociationsContainer)) {
            throw new IllegalArgumentException("categories must be of type " + CategoryAssociationsContainer.class.getSimpleName());
        }
        super.addFields(doc, categories);
    }

    static {
        DRILL_DOWN_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        DRILL_DOWN_TYPE.freeze();
    }
}

