/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.facet.associations.CategoryAssociation;
import org.apache.lucene.facet.associations.CategoryAssociationsContainer;
import org.apache.lucene.facet.index.DrillDownStream;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;

public class AssociationsDrillDownStream
extends DrillDownStream {
    private final PayloadAttribute payloadAttribute;
    private final BytesRef payload;
    private final ByteArrayDataOutput output = new ByteArrayDataOutput();
    private final CategoryAssociationsContainer associations;

    public AssociationsDrillDownStream(CategoryAssociationsContainer associations, FacetIndexingParams indexingParams) {
        super(associations, indexingParams);
        this.associations = associations;
        this.payloadAttribute = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        BytesRef bytes = this.payloadAttribute.getPayload();
        if (bytes == null) {
            bytes = new BytesRef(new byte[4]);
            this.payloadAttribute.setPayload(bytes);
        }
        bytes.offset = 0;
        this.payload = bytes;
    }

    @Override
    protected void addAdditionalAttributes(CategoryPath cp, boolean isParent) {
        if (isParent) {
            return;
        }
        CategoryAssociation association = this.associations.getAssociation(cp);
        if (association == null) {
            return;
        }
        if (this.payload.bytes.length < association.maxBytesNeeded()) {
            this.payload.grow(association.maxBytesNeeded());
        }
        this.output.reset(this.payload.bytes);
        association.serialize(this.output);
        this.payload.length = this.output.getPosition();
    }
}

