/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.ScoredDocIDsIterator;
import org.apache.lucene.facet.util.ScoredDocIdsUtils;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.Version;

public class RandomSample {
    private static final Logger logger = Logger.getLogger(RandomSample.class.getName());
    private static final int N_PRIMES = 4000;
    private static int[] primes = new int[4000];
    private static final long PHI_32 = 2654435769L;
    private static final long PHI_32I = 340573321L;
    private static boolean returnTimings;

    public static int[] repeatableSample(ScoredDocIDs collection, int collectionSize, int sampleSize) throws IOException {
        return RandomSample.repeatableSample(collection, collectionSize, sampleSize, Algorithm.HASHING, Sorted.NO);
    }

    public static int[] repeatableSample(ScoredDocIDs collection, int collectionSize, int sampleSize, Algorithm algorithm, Sorted sorted) throws IOException {
        if (collection == null) {
            throw new IOException("docIdSet is null");
        }
        if (sampleSize < 1) {
            throw new IOException("sampleSize < 1 (" + sampleSize + ")");
        }
        if (collectionSize < sampleSize) {
            throw new IOException("collectionSize (" + collectionSize + ") less than sampleSize (" + sampleSize + ")");
        }
        int[] sample = new int[sampleSize];
        long[] times = new long[4];
        if (algorithm == Algorithm.TRAVERSAL) {
            RandomSample.sample1(collection, collectionSize, sample, times);
        } else if (algorithm == Algorithm.HASHING) {
            RandomSample.sample2(collection, collectionSize, sample, times);
        } else {
            throw new IllegalArgumentException("Invalid algorithm selection");
        }
        if (sorted == Sorted.YES) {
            Arrays.sort(sample);
        }
        if (returnTimings) {
            times[3] = System.currentTimeMillis();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Times: " + (times[1] - times[0]) + "ms, " + (times[2] - times[1]) + "ms, " + (times[3] - times[2]) + "ms");
            }
        }
        return sample;
    }

    private static void sample1(ScoredDocIDs collection, int collectionSize, int[] sample, long[] times) throws IOException {
        ScoredDocIDsIterator it = collection.iterator();
        if (returnTimings) {
            times[0] = System.currentTimeMillis();
        }
        int sampleSize = sample.length;
        int prime = RandomSample.findGoodStepSize(collectionSize, sampleSize);
        int mod = prime % collectionSize;
        if (returnTimings) {
            times[1] = System.currentTimeMillis();
        }
        int sampleCount = 0;
        int index = 0;
        while (sampleCount < sampleSize) {
            int i;
            if (index + mod < collectionSize) {
                i = 0;
                while (i < mod) {
                    it.next();
                    ++i;
                    ++index;
                }
            } else {
                index = index + mod - collectionSize;
                it = collection.iterator();
                for (i = 0; i < index; ++i) {
                    it.next();
                }
            }
            sample[sampleCount++] = it.getDocID();
        }
        if (returnTimings) {
            times[2] = System.currentTimeMillis();
        }
    }

    private static int findGoodStepSize(int collectionSize, int sampleSize) {
        int i = (int)Math.sqrt(collectionSize);
        if (sampleSize < i) {
            i = collectionSize / sampleSize;
        }
        while (collectionSize % (i = RandomSample.findNextPrimeAfter(i)) == 0) {
        }
        return i;
    }

    private static int findNextPrimeAfter(int n) {
        n += n % 2 == 0 ? 1 : 2;
        while (true) {
            block6: {
                int sri = (int)Math.sqrt(n);
                for (int primeIndex = 0; primeIndex < 4000; ++primeIndex) {
                    int p = primes[primeIndex];
                    if (p > sri) {
                        return n;
                    }
                    if (n % p != 0) {
                        continue;
                    }
                    break block6;
                }
                int p = primes[3999] + 2;
                while (true) {
                    if (p > sri) {
                        return n;
                    }
                    if (n % p == 0) break;
                    p += 2;
                }
            }
            n += 2;
        }
    }

    private static int[] countsBySubrange(int[] collection, int range, int numSubranges) {
        int[] counts = new int[numSubranges];
        Arrays.fill(counts, 0);
        int numInSubrange = range / numSubranges;
        for (int j = 0; j < collection.length; ++j) {
            int n = collection[j] / numInSubrange;
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    public static int[] factor(long value) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (value > 1L && value % 2L == 0L) {
            list.add(2);
            value /= 2L;
        }
        long sqrt = Math.round(Math.sqrt(value));
        for (int p : primes) {
            if ((long)p >= sqrt) break;
            while (value % (long)p == 0L) {
                list.add(p);
                sqrt = Math.round(Math.sqrt(value /= (long)p));
            }
        }
        if (list.size() == 0 || value > Integer.MAX_VALUE) {
            throw new RuntimeException("Prime or too large to factor: " + value);
        }
        if ((int)value > 1) {
            list.add((int)value);
        }
        int[] factors = new int[list.size()];
        for (int j = 0; j < factors.length; ++j) {
            factors[j] = (Integer)list.get(j);
        }
        return factors;
    }

    private static void sample2(ScoredDocIDs collection, int collectionSize, int[] sample, long[] times) throws IOException {
        if (returnTimings) {
            times[0] = System.currentTimeMillis();
        }
        int sampleSize = sample.length;
        IntPriorityQueue pq = new IntPriorityQueue(sampleSize);
        ScoredDocIDsIterator it = collection.iterator();
        while (it.next()) {
            pq.insertWithReuse((int)((long)it.getDocID() * 2654435769L) & Integer.MAX_VALUE);
        }
        if (returnTimings) {
            times[1] = System.currentTimeMillis();
        }
        Object[] heap = pq.getHeap();
        for (int si = 0; si < sampleSize; ++si) {
            sample[si] = (int)((long)((IntPriorityQueue.MI)heap[si + 1]).value * 340573321L) & Integer.MAX_VALUE;
        }
        if (returnTimings) {
            times[2] = System.currentTimeMillis();
        }
    }

    public static void main(String[] args) throws Exception {
        returnTimings = true;
        int COLLECTION_SIZE = 10000000;
        ScoredDocIDs collection = RandomSample.createAllScoredDocs(10000000);
        int[] sampleSizes = new int[]{10, 57, 100, 333, 1000, 2154, 10000};
        Algorithm[] algorithms = new Algorithm[]{Algorithm.HASHING, Algorithm.TRAVERSAL};
        for (int sampleSize : sampleSizes) {
            for (Algorithm algorithm : algorithms) {
                int j;
                System.out.println("Sample size " + sampleSize + ", algorithm " + algorithm + "...");
                int[] sample = RandomSample.repeatableSample(collection, 10000000, sampleSize, algorithm, Sorted.YES);
                boolean noDups = true;
                for (int j2 = 0; j2 < sampleSize - 1; ++j2) {
                    if (sample[j2] != sample[j2 + 1]) continue;
                    System.out.println("Duplicate value " + sample[j2] + " at " + j2 + ", " + (j2 + 1));
                    noDups = false;
                    break;
                }
                if (noDups) {
                    System.out.println("No duplicates.");
                }
                if (algorithm == Algorithm.HASHING) {
                    System.out.print("Hashed sample, up to 100 of " + sampleSize + ": ");
                    int lim = Math.min(100, sampleSize);
                    for (int k = 0; k < lim; ++k) {
                        System.out.print(sample[k] + ", ");
                    }
                    System.out.println("");
                }
                int N_INTERVALS = 100;
                int[] counts = RandomSample.countsBySubrange(sample, 10000000, 100);
                int minCount = Integer.MAX_VALUE;
                int maxCount = Integer.MIN_VALUE;
                int avgCount = 0;
                for (j = 0; j < 100; ++j) {
                    int count = counts[j];
                    if (count < minCount) {
                        minCount = count;
                    }
                    if (count > maxCount) {
                        maxCount = count;
                    }
                    avgCount += count;
                }
                System.out.println("Min, max, avg: " + minCount + ", " + maxCount + ", " + (avgCount /= 100));
                if (((double)minCount - (double)avgCount) / (double)avgCount < -0.05 && minCount - avgCount < -5) {
                    System.out.println("Not flat enough.");
                } else if (((double)maxCount - (double)avgCount) / (double)avgCount > 0.05 && maxCount - avgCount > 5) {
                    System.out.println("Not flat enough.");
                } else {
                    System.out.println("Flat enough.");
                }
                if (sampleSize != 10544 || algorithm != Algorithm.TRAVERSAL) continue;
                System.out.print("Counts of interest: ");
                for (j = 0; j < 100; ++j) {
                    System.out.print(counts[j] + ", ");
                }
                System.out.println("");
            }
        }
        System.out.println("Last prime is " + primes[3999]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScoredDocIDs createAllScoredDocs(int COLLECTION_SIZE) throws CorruptIndexException, LockObtainFailedException, IOException {
        ScoredDocIDs collection;
        IndexReader reader = null;
        RAMDirectory ramDir = new RAMDirectory();
        try {
            IndexWriter writer = new IndexWriter((Directory)ramDir, new IndexWriterConfig(Version.LUCENE_30, (Analyzer)new KeywordAnalyzer()));
            for (int i = 0; i < COLLECTION_SIZE; ++i) {
                writer.addDocument(new Document());
            }
            writer.commit();
            writer.close();
            reader = IndexReader.open((Directory)ramDir);
            collection = ScoredDocIdsUtils.createAllDocsScoredDocIDs(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            ramDir.close();
        }
        return collection;
    }

    static {
        RandomSample.primes[0] = 3;
        for (int count = 1; count < 4000; ++count) {
            RandomSample.primes[count] = RandomSample.findNextPrimeAfter(primes[count - 1]);
        }
        returnTimings = false;
    }

    public static class Sorted {
        public static final Sorted YES = new Sorted("sorted");
        public static final Sorted NO = new Sorted("unsorted");
        private String name;

        private Sorted(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Algorithm {
        public static final Algorithm TRAVERSAL = new Algorithm("Traversal");
        public static final Algorithm HASHING = new Algorithm("Hashing");
        private String name;

        private Algorithm(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntPriorityQueue
    extends PriorityQueue<Object> {
        private MI mi;

        public IntPriorityQueue(int size) {
            this.initialize(size);
        }

        public void insertWithReuse(int intval) {
            if (this.mi == null) {
                this.mi = new MI();
            }
            this.mi.value = intval;
            this.mi = (MI)this.insertWithOverflow(this.mi);
        }

        public Object[] getHeap() {
            return this.getHeapArray();
        }

        public boolean lessThan(Object o1, Object o2) {
            return ((MI)o1).value < ((MI)o2).value;
        }

        private static class MI {
            public int value;

            MI() {
            }
        }
    }
}

