/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import java.io.IOException;
import java.io.Reader;
import java.text.Collator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.collation.CollationKeyFilter;

public class CollationKeyAnalyzer
extends Analyzer {
    private Collator collator;

    public CollationKeyAnalyzer(Collator collator) {
        this.collator = collator;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new KeywordTokenizer(reader);
        result = new CollationKeyFilter((TokenStream)result, this.collator);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new KeywordTokenizer(reader);
            streams.result = new CollationKeyFilter((TokenStream)streams.source, this.collator);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

