/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.FSTDictionary;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTermsWriter;
import org.apache.lucene.codecs.uniformsplit.sharedterms.FieldMetadataTermState;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STBlockWriter;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STMergingBlockReader;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STMergingTermsEnum;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STUniformSplitTerms;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.PriorityQueue;

public class STUniformSplitTermsWriter
extends UniformSplitTermsWriter {
    public STUniformSplitTermsWriter(PostingsWriterBase postingsWriter, SegmentWriteState state, BlockEncoder blockEncoder) throws IOException {
        this(postingsWriter, state, 32, 3, blockEncoder);
    }

    public STUniformSplitTermsWriter(PostingsWriterBase postingsWriter, SegmentWriteState state, int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder) throws IOException {
        this(postingsWriter, state, targetNumBlockLines, deltaNumLines, blockEncoder, FieldMetadata.Serializer.INSTANCE, "SharedTermsUniformSplit", 1, "stustb", "stustd");
    }

    protected STUniformSplitTermsWriter(PostingsWriterBase postingsWriter, SegmentWriteState state, int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder, FieldMetadata.Serializer fieldMetadataWriter, String codecName, int versionCurrent, String termsBlocksExtension, String dictionaryExtension) throws IOException {
        super(postingsWriter, state, targetNumBlockLines, deltaNumLines, blockEncoder, fieldMetadataWriter, codecName, versionCurrent, termsBlocksExtension, dictionaryExtension);
    }

    @Override
    public void write(Fields fields, NormsProducer normsProducer) throws IOException {
        this.writeSegment((blockWriter, dictionaryBuilder) -> this.writeSingleSegment(fields, normsProducer, blockWriter, dictionaryBuilder));
    }

    private void writeSegment(SharedTermsWriter termsWriter) throws IOException {
        STBlockWriter blockWriter = new STBlockWriter(this.blockOutput, this.targetNumBlockLines, this.deltaNumLines, this.blockEncoder);
        FSTDictionary.Builder dictionaryBuilder = new FSTDictionary.Builder();
        Collection<FieldMetadata> fieldMetadataList = termsWriter.writeSharedTerms(blockWriter, dictionaryBuilder);
        blockWriter.finishLastBlock(dictionaryBuilder);
        int fieldsNumber = this.writeFieldMetadataList(fieldMetadataList);
        this.writeDictionary(fieldsNumber, dictionaryBuilder);
    }

    private Collection<FieldMetadata> writeSingleSegment(Fields fields, NormsProducer normsProducer, STBlockWriter blockWriter, IndexDictionary.Builder dictionaryBuilder) throws IOException {
        List<FieldMetadata> fieldMetadataList = this.createFieldMetadataList(new FieldsIterator(fields, this.fieldInfos), this.maxDoc);
        TermIteratorQueue<FieldTerms> fieldTermsQueue = this.createFieldTermsQueue(fields, fieldMetadataList);
        ArrayList groupedFieldTerms = new ArrayList(fieldTermsQueue.size());
        ArrayList<FieldMetadataTermState> termStates = new ArrayList<FieldMetadataTermState>(fieldTermsQueue.size());
        while (fieldTermsQueue.size() != 0) {
            TermIterator<FieldTerms> topFieldTerms = fieldTermsQueue.popTerms();
            BytesRef term = BytesRef.deepCopyOf((BytesRef)topFieldTerms.term);
            this.groupByTerm(fieldTermsQueue, topFieldTerms, groupedFieldTerms);
            this.writePostingLines(term, groupedFieldTerms, normsProducer, termStates);
            blockWriter.addLine(term, termStates, dictionaryBuilder);
            this.nextTermForIterators(groupedFieldTerms, fieldTermsQueue);
        }
        return fieldMetadataList;
    }

    private List<FieldMetadata> createFieldMetadataList(Iterator<FieldInfo> fieldInfos, int maxDoc) {
        ArrayList<FieldMetadata> fieldMetadataList = new ArrayList<FieldMetadata>();
        while (fieldInfos.hasNext()) {
            FieldMetadata fieldMetadata = new FieldMetadata(fieldInfos.next(), maxDoc);
            fieldMetadata.setDictionaryStartFP(this.dictionaryOutput.getFilePointer());
            fieldMetadataList.add(fieldMetadata);
        }
        return fieldMetadataList;
    }

    private TermIteratorQueue<FieldTerms> createFieldTermsQueue(Fields fields, List<FieldMetadata> fieldMetadataList) throws IOException {
        TermIteratorQueue<FieldTerms> fieldQueue = new TermIteratorQueue<FieldTerms>(fieldMetadataList.size());
        for (FieldMetadata fieldMetadata : fieldMetadataList) {
            FieldTerms fieldTerms;
            Terms terms = fields.terms(fieldMetadata.getFieldInfo().name);
            if (terms == null || !(fieldTerms = new FieldTerms(fieldMetadata, terms.iterator())).nextTerm()) continue;
            fieldQueue.add(fieldTerms);
        }
        return fieldQueue;
    }

    private <T> void groupByTerm(TermIteratorQueue<T> termIteratorQueue, TermIterator<T> topTermIterator, List<TermIterator<T>> groupedTermIterators) {
        groupedTermIterators.clear();
        groupedTermIterators.add(topTermIterator);
        while (termIteratorQueue.size() != 0) {
            TermIterator termIterator = (TermIterator)termIteratorQueue.top();
            if (topTermIterator.term.compareTo(termIterator.term) != 0) {
                return;
            }
            groupedTermIterators.add(termIterator);
            termIteratorQueue.pop();
        }
    }

    private void writePostingLines(BytesRef term, List<? extends TermIterator<FieldTerms>> groupedFieldTerms, NormsProducer normsProducer, List<FieldMetadataTermState> termStates) throws IOException {
        termStates.clear();
        for (TermIterator<FieldTerms> termIterator : groupedFieldTerms) {
            FieldTerms fieldTerms = (FieldTerms)termIterator;
            this.postingsWriter.setField(fieldTerms.fieldMetadata.getFieldInfo());
            BlockTermState blockTermState = this.writePostingLine(fieldTerms.termsEnum, fieldTerms.fieldMetadata, normsProducer);
            if (blockTermState == null) continue;
            fieldTerms.fieldMetadata.setLastTerm(term);
            termStates.add(new FieldMetadataTermState(fieldTerms.fieldMetadata, blockTermState));
        }
    }

    private <T> void nextTermForIterators(List<? extends TermIterator<T>> termIterators, TermIteratorQueue<T> termIteratorQueue) throws IOException {
        for (TermIterator<T> termIterator : termIterators) {
            if (!termIterator.nextTerm()) continue;
            termIteratorQueue.add(termIterator);
        }
    }

    private int writeFieldMetadataList(Collection<FieldMetadata> fieldMetadataList) throws IOException {
        ByteBuffersDataOutput fieldsOutput = new ByteBuffersDataOutput();
        int fieldsNumber = 0;
        for (FieldMetadata fieldMetadata : fieldMetadataList) {
            if (fieldMetadata.getNumTerms() <= 0L) continue;
            this.fieldMetadataWriter.write((DataOutput)fieldsOutput, fieldMetadata);
            ++fieldsNumber;
        }
        this.writeFieldsMetadata(fieldsNumber, fieldsOutput);
        return fieldsNumber;
    }

    protected void writeDictionary(int fieldsNumber, IndexDictionary.Builder dictionaryBuilder) throws IOException {
        if (fieldsNumber > 0) {
            this.writeDictionary(dictionaryBuilder);
        }
        CodecUtil.writeFooter((IndexOutput)this.dictionaryOutput);
    }

    public void merge(MergeState mergeState, NormsProducer normsProducer) throws IOException {
        if (mergeState.needsIndexSort) {
            super.merge(mergeState, normsProducer);
            return;
        }
        FieldsProducer[] fieldsProducers = mergeState.fieldsProducers;
        ArrayList<SegmentTerms> segmentTermsList = new ArrayList<SegmentTerms>(fieldsProducers.length);
        block0: for (int segmentIndex = 0; segmentIndex < fieldsProducers.length; ++segmentIndex) {
            FieldsProducer fieldsProducer = fieldsProducers[segmentIndex];
            for (FieldInfo fieldInfo : mergeState.fieldInfos[segmentIndex]) {
                Terms terms = fieldsProducer.terms(fieldInfo.name);
                if (terms == null) continue;
                if (!(terms instanceof STUniformSplitTerms)) {
                    super.merge(mergeState, normsProducer);
                    return;
                }
                STUniformSplitTerms sharedTerms = (STUniformSplitTerms)terms;
                segmentTermsList.add(new SegmentTerms(segmentIndex, sharedTerms.createMergingBlockReader(), mergeState.docMaps[segmentIndex]));
                continue block0;
            }
        }
        this.writeSegment((blockWriter, dictionaryBuilder) -> this.mergeSegments(mergeState, normsProducer, segmentTermsList, blockWriter, dictionaryBuilder));
    }

    private Collection<FieldMetadata> mergeSegments(MergeState mergeState, NormsProducer normsProducer, List<TermIterator<SegmentTerms>> segmentTermsList, STBlockWriter blockWriter, IndexDictionary.Builder dictionaryBuilder) throws IOException {
        List<FieldMetadata> fieldMetadataList = this.createFieldMetadataList(mergeState.mergeFieldInfos.iterator(), mergeState.segmentInfo.maxDoc());
        Map<String, MergingFieldTerms> fieldTermsMap = this.createMergingFieldTermsMap(fieldMetadataList, mergeState.fieldsProducers.length);
        TermIteratorQueue<SegmentTerms> segmentTermsQueue = this.createSegmentTermsQueue(segmentTermsList);
        ArrayList<TermIterator<SegmentTerms>> groupedSegmentTerms = new ArrayList<TermIterator<SegmentTerms>>(segmentTermsList.size());
        HashMap fieldPostingsMap = CollectionUtil.newHashMap((int)mergeState.fieldInfos.length);
        ArrayList<MergingFieldTerms> groupedFieldTerms = new ArrayList<MergingFieldTerms>(mergeState.fieldInfos.length);
        ArrayList<FieldMetadataTermState> termStates = new ArrayList<FieldMetadataTermState>(mergeState.fieldInfos.length);
        while (segmentTermsQueue.size() != 0) {
            TermIterator<SegmentTerms> topSegmentTerms = segmentTermsQueue.popTerms();
            BytesRef term = BytesRef.deepCopyOf((BytesRef)topSegmentTerms.term);
            this.groupByTerm(segmentTermsQueue, topSegmentTerms, groupedSegmentTerms);
            this.combineSegmentsFields(groupedSegmentTerms, fieldPostingsMap);
            this.combinePostingsPerField(term, fieldTermsMap, fieldPostingsMap, groupedFieldTerms);
            this.writePostingLines(term, groupedFieldTerms, normsProducer, termStates);
            blockWriter.addLine(term, termStates, dictionaryBuilder);
            this.nextTermForIterators(groupedSegmentTerms, segmentTermsQueue);
        }
        return fieldMetadataList;
    }

    private Map<String, MergingFieldTerms> createMergingFieldTermsMap(List<FieldMetadata> fieldMetadataList, int numSegments) {
        HashMap fieldTermsMap = CollectionUtil.newHashMap((int)fieldMetadataList.size());
        for (FieldMetadata fieldMetadata : fieldMetadataList) {
            FieldInfo fieldInfo = fieldMetadata.getFieldInfo();
            fieldTermsMap.put(fieldInfo.name, new MergingFieldTerms(fieldMetadata, new STMergingTermsEnum(fieldInfo.name, numSegments)));
        }
        return fieldTermsMap;
    }

    private TermIteratorQueue<SegmentTerms> createSegmentTermsQueue(List<TermIterator<SegmentTerms>> segmentTermsList) throws IOException {
        TermIteratorQueue<SegmentTerms> segmentQueue = new TermIteratorQueue<SegmentTerms>(segmentTermsList.size());
        for (TermIterator<SegmentTerms> segmentTerms : segmentTermsList) {
            if (!segmentTerms.nextTerm()) continue;
            segmentQueue.add(segmentTerms);
        }
        return segmentQueue;
    }

    private void combineSegmentsFields(List<TermIterator<SegmentTerms>> groupedSegmentTerms, Map<String, List<SegmentPostings>> fieldPostingsMap) {
        fieldPostingsMap.clear();
        for (TermIterator<SegmentTerms> segmentTermIterator : groupedSegmentTerms) {
            SegmentTerms segmentTerms = (SegmentTerms)segmentTermIterator;
            for (Map.Entry<String, BlockTermState> fieldTermState : segmentTerms.fieldTermStatesMap.entrySet()) {
                List segmentPostingsList = fieldPostingsMap.computeIfAbsent(fieldTermState.getKey(), k -> new ArrayList(groupedSegmentTerms.size()));
                segmentPostingsList.add(new SegmentPostings(segmentTerms.segmentIndex, fieldTermState.getValue(), segmentTerms.mergingBlockReader, segmentTerms.docMap));
            }
        }
    }

    private void combinePostingsPerField(BytesRef term, Map<String, MergingFieldTerms> fieldTermsMap, Map<String, List<SegmentPostings>> fieldPostingsMap, List<MergingFieldTerms> groupedFieldTerms) {
        groupedFieldTerms.clear();
        for (Map.Entry<String, List<SegmentPostings>> fieldPostingsEntry : fieldPostingsMap.entrySet()) {
            MergingFieldTerms fieldTerms2 = fieldTermsMap.get(fieldPostingsEntry.getKey());
            if (fieldTerms2 == null) continue;
            fieldTerms2.resetIterator(term, fieldPostingsEntry.getValue());
            groupedFieldTerms.add(fieldTerms2);
        }
        groupedFieldTerms.sort(Comparator.comparingInt(fieldTerms -> fieldTerms.fieldMetadata.getFieldInfo().number));
    }

    private static interface SharedTermsWriter {
        public Collection<FieldMetadata> writeSharedTerms(STBlockWriter var1, IndexDictionary.Builder var2) throws IOException;
    }

    private static class FieldsIterator
    implements Iterator<FieldInfo> {
        private final Iterator<String> fieldNames;
        private final FieldInfos fieldInfos;

        FieldsIterator(Fields fields, FieldInfos fieldInfos) {
            this.fieldNames = fields.iterator();
            this.fieldInfos = fieldInfos;
        }

        @Override
        public boolean hasNext() {
            return this.fieldNames.hasNext();
        }

        @Override
        public FieldInfo next() {
            return this.fieldInfos.fieldInfo(this.fieldNames.next());
        }
    }

    private class TermIteratorQueue<T>
    extends PriorityQueue<TermIterator<T>> {
        TermIteratorQueue(int numFields) {
            super(numFields);
        }

        protected boolean lessThan(TermIterator<T> a, TermIterator<T> b) {
            return a.compareTo(b) < 0;
        }

        TermIterator<T> popTerms() {
            TermIterator topTerms = (TermIterator)this.pop();
            assert (topTerms != null);
            assert (topTerms.term != null);
            return topTerms;
        }
    }

    private abstract class TermIterator<T>
    implements Comparable<TermIterator<T>> {
        BytesRef term;

        private TermIterator() {
        }

        abstract boolean nextTerm() throws IOException;

        @Override
        public int compareTo(TermIterator<T> other) {
            assert (this.term != null) : "Should not be compared when the iterator is exhausted";
            int comparison = this.term.compareTo(other.term);
            if (comparison == 0) {
                return this.compareSecondary(other);
            }
            return comparison;
        }

        abstract int compareSecondary(TermIterator<T> var1);
    }

    private class FieldTerms
    extends TermIterator<FieldTerms> {
        final FieldMetadata fieldMetadata;
        final TermsEnum termsEnum;

        FieldTerms(FieldMetadata fieldMetadata, TermsEnum termsEnum) {
            this.fieldMetadata = fieldMetadata;
            this.termsEnum = termsEnum;
        }

        @Override
        boolean nextTerm() throws IOException {
            this.term = this.termsEnum.next();
            return this.term != null;
        }

        @Override
        int compareSecondary(TermIterator<FieldTerms> other) {
            return Integer.compare(this.fieldMetadata.getFieldInfo().number, ((FieldTerms)other).fieldMetadata.getFieldInfo().number);
        }
    }

    private class SegmentTerms
    extends TermIterator<SegmentTerms> {
        private final Integer segmentIndex;
        private final STMergingBlockReader mergingBlockReader;
        private final Map<String, BlockTermState> fieldTermStatesMap;
        private final MergeState.DocMap docMap;

        SegmentTerms(int segmentIndex, STMergingBlockReader mergingBlockReader, MergeState.DocMap docMap) {
            this.segmentIndex = segmentIndex;
            this.mergingBlockReader = mergingBlockReader;
            this.docMap = docMap;
            this.fieldTermStatesMap = new HashMap<String, BlockTermState>();
        }

        @Override
        boolean nextTerm() throws IOException {
            this.term = this.mergingBlockReader.next();
            if (this.term == null) {
                return false;
            }
            this.mergingBlockReader.readFieldTermStatesMap(this.fieldTermStatesMap);
            return true;
        }

        @Override
        int compareSecondary(TermIterator<SegmentTerms> other) {
            return Integer.compare(this.segmentIndex, ((SegmentTerms)other).segmentIndex);
        }
    }

    private class MergingFieldTerms
    extends FieldTerms {
        MergingFieldTerms(FieldMetadata fieldMetadata, STMergingTermsEnum termsEnum) {
            super(fieldMetadata, termsEnum);
        }

        void resetIterator(BytesRef term, List<SegmentPostings> segmentPostingsList) {
            ((STMergingTermsEnum)this.termsEnum).reset(term, segmentPostingsList);
        }
    }

    final class SegmentPostings {
        final int segmentIndex;
        final BlockTermState termState;
        final STMergingBlockReader mergingBlockReader;
        final MergeState.DocMap docMap;

        SegmentPostings(int segmentIndex, BlockTermState termState, STMergingBlockReader mergingBlockReader, MergeState.DocMap docMap) {
            this.segmentIndex = segmentIndex;
            this.termState = termState;
            this.mergingBlockReader = mergingBlockReader;
            this.docMap = docMap;
        }

        PostingsEnum getPostings(String fieldName, PostingsEnum reuse, int flags) throws IOException {
            return this.mergingBlockReader.postings(fieldName, this.termState, reuse, flags);
        }
    }
}

