/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class FSTDictionary
implements IndexDictionary {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(FSTDictionary.class);
    protected final FST<Long> dictionary;

    protected FSTDictionary(FST<Long> dictionary) {
        this.dictionary = dictionary;
    }

    public long ramBytesUsed() {
        return BASE_RAM_USAGE + this.dictionary.ramBytesUsed();
    }

    @Override
    public void write(DataOutput output, BlockEncoder blockEncoder) throws IOException {
        if (blockEncoder == null) {
            this.dictionary.save(output);
        } else {
            ByteBuffersDataOutput bytesDataOutput = ByteBuffersDataOutput.newResettableInstance();
            this.dictionary.save((DataOutput)bytesDataOutput);
            BlockEncoder.WritableBytes encodedBytes = blockEncoder.encode((DataInput)bytesDataOutput.toDataInput(), bytesDataOutput.size());
            output.writeVLong(encodedBytes.size());
            encodedBytes.writeTo(output);
        }
    }

    protected static FSTDictionary read(DataInput input, BlockDecoder blockDecoder) throws IOException {
        DataInput fstDataInput;
        if (blockDecoder == null) {
            fstDataInput = input;
        } else {
            long numBytes = input.readVLong();
            BytesRef decodedBytes = blockDecoder.decode(input, numBytes);
            fstDataInput = new ByteArrayDataInput(decodedBytes.bytes, 0, decodedBytes.length);
        }
        PositiveIntOutputs fstOutputs = PositiveIntOutputs.getSingleton();
        FST dictionary = new FST(fstDataInput, (Outputs)fstOutputs);
        return new FSTDictionary((FST<Long>)dictionary);
    }

    @Override
    public Browser browser() {
        return new Browser();
    }

    public static class Builder
    implements IndexDictionary.Builder {
        protected final org.apache.lucene.util.fst.Builder<Long> fstBuilder;
        protected final IntsRefBuilder scratchInts;

        public Builder() {
            PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
            this.fstBuilder = new org.apache.lucene.util.fst.Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
            this.scratchInts = new IntsRefBuilder();
        }

        @Override
        public void add(BytesRef blockKey, long blockFilePointer) {
            try {
                this.fstBuilder.add(Util.toIntsRef((BytesRef)blockKey, (IntsRefBuilder)this.scratchInts), (Object)blockFilePointer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public FSTDictionary build() {
            try {
                return new FSTDictionary((FST<Long>)this.fstBuilder.finish());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class Browser
    implements IndexDictionary.Browser {
        protected final BytesRefFSTEnum<Long> fstEnum;
        protected static final int STATE_SEEK = 0;
        protected static final int STATE_NEXT = 1;
        protected static final int STATE_END = 2;
        protected int state;
        protected final BytesRefBuilder keyBuilder;
        protected int blockPrefixLen;
        protected long blockFilePointer;

        protected Browser() {
            this.fstEnum = new BytesRefFSTEnum(FSTDictionary.this.dictionary);
            this.state = 0;
            this.keyBuilder = new BytesRefBuilder();
            this.blockPrefixLen = 0;
            this.blockFilePointer = -1L;
        }

        @Override
        public long seekBlock(BytesRef term) {
            this.state = 0;
            try {
                BytesRefFSTEnum.InputOutput seekFloor = this.fstEnum.seekFloor(term);
                this.blockFilePointer = seekFloor == null ? -1L : (Long)seekFloor.output;
                return this.blockFilePointer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public BytesRef nextKey() {
            try {
                if (this.state == 2) {
                    return null;
                }
                if (this.state == 0 && this.blockFilePointer == -1L && this.fstEnum.next() == null) {
                    this.state = 2;
                    return null;
                }
                this.keyBuilder.copyBytes(this.fstEnum.current().input);
                this.blockFilePointer = (Long)this.fstEnum.current().output;
                assert (this.blockFilePointer >= 0L);
                this.state = 1;
                BytesRef key = this.keyBuilder.get();
                BytesRefFSTEnum.InputOutput inputOutput = this.fstEnum.next();
                if (inputOutput == null) {
                    this.state = 2;
                    this.blockPrefixLen = 0;
                } else {
                    int sortKeyLength = StringHelper.sortKeyLength((BytesRef)key, (BytesRef)inputOutput.input);
                    assert (sortKeyLength >= 1);
                    this.blockPrefixLen = sortKeyLength - 1;
                }
                return key;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public BytesRef peekKey() {
            assert (this.state != 0);
            return this.state == 2 ? null : this.fstEnum.current().input;
        }

        @Override
        public int getBlockPrefixLen() {
            assert (this.state != 0);
            assert (this.blockPrefixLen >= 0);
            return this.blockPrefixLen;
        }

        @Override
        public long getBlockFilePointer() {
            assert (this.state != 0);
            assert (this.blockFilePointer >= 0L);
            return this.blockFilePointer;
        }
    }
}

