/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public class SimpleTextSegmentInfoFormat
extends SegmentInfoFormat {
    static final BytesRef SI_VERSION = new BytesRef((CharSequence)"    version ");
    static final BytesRef SI_DOCCOUNT = new BytesRef((CharSequence)"    number of documents ");
    static final BytesRef SI_USECOMPOUND = new BytesRef((CharSequence)"    uses compound file ");
    static final BytesRef SI_NUM_DIAG = new BytesRef((CharSequence)"    diagnostics ");
    static final BytesRef SI_DIAG_KEY = new BytesRef((CharSequence)"      key ");
    static final BytesRef SI_DIAG_VALUE = new BytesRef((CharSequence)"      value ");
    static final BytesRef SI_NUM_ATT = new BytesRef((CharSequence)"    attributes ");
    static final BytesRef SI_ATT_KEY = new BytesRef((CharSequence)"      key ");
    static final BytesRef SI_ATT_VALUE = new BytesRef((CharSequence)"      value ");
    static final BytesRef SI_NUM_FILES = new BytesRef((CharSequence)"    files ");
    static final BytesRef SI_FILE = new BytesRef((CharSequence)"      file ");
    static final BytesRef SI_ID = new BytesRef((CharSequence)"    id ");
    public static final String SI_EXTENSION = "si";

    public SegmentInfo read(Directory directory, String segmentName, byte[] segmentID, IOContext context) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        String segFileName = IndexFileNames.segmentFileName((String)segmentName, (String)"", (String)SI_EXTENSION);
        try (ChecksumIndexInput input = directory.openChecksumInput(segFileName, context);){
            Version version;
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_VERSION));
            try {
                version = Version.parse((String)this.readString(SimpleTextSegmentInfoFormat.SI_VERSION.length, scratch));
            }
            catch (ParseException pe) {
                throw new CorruptIndexException("unable to parse version string: " + pe.getMessage(), (DataInput)input, (Throwable)pe);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DOCCOUNT));
            int docCount = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_DOCCOUNT.length, scratch));
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_USECOMPOUND));
            boolean isCompoundFile = Boolean.parseBoolean(this.readString(SimpleTextSegmentInfoFormat.SI_USECOMPOUND.length, scratch));
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_DIAG));
            int numDiag = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_DIAG.length, scratch));
            HashMap<String, String> diagnostics = new HashMap<String, String>();
            for (int i = 0; i < numDiag; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DIAG_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_KEY.length, scratch);
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DIAG_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_VALUE.length, scratch);
                diagnostics.put(key, value);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_ATT));
            int numAtt = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_ATT.length, scratch));
            HashMap<String, String> attributes = new HashMap<String, String>(numAtt);
            for (int i = 0; i < numAtt; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ATT_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_KEY.length, scratch);
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ATT_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_VALUE.length, scratch);
                attributes.put(key, value);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_FILES));
            int numFiles = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_FILES.length, scratch));
            HashSet<String> files = new HashSet<String>();
            for (int i = 0; i < numFiles; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_FILE));
                String fileName = this.readString(SimpleTextSegmentInfoFormat.SI_FILE.length, scratch);
                files.add(fileName);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ID));
            byte[] id = Arrays.copyOfRange(scratch.bytes(), SimpleTextSegmentInfoFormat.SI_ID.length, scratch.length());
            if (!Arrays.equals(segmentID, id)) {
                throw new CorruptIndexException("file mismatch, expected: " + StringHelper.idToString((byte[])segmentID) + ", got: " + StringHelper.idToString((byte[])id), (DataInput)input);
            }
            SimpleTextUtil.checkFooter(input);
            SegmentInfo info = new SegmentInfo(directory, version, segmentName, docCount, isCompoundFile, null, diagnostics, id, Collections.unmodifiableMap(attributes));
            info.setFiles(files);
            SegmentInfo segmentInfo = info;
            return segmentInfo;
        }
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }

    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        String segFileName = IndexFileNames.segmentFileName((String)si.name, (String)"", (String)SI_EXTENSION);
        si.addFile(segFileName);
        try (IndexOutput output = dir.createOutput(segFileName, ioContext);){
            BytesRefBuilder scratch = new BytesRefBuilder();
            SimpleTextUtil.write((DataOutput)output, SI_VERSION);
            SimpleTextUtil.write((DataOutput)output, si.getVersion().toString(), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.write((DataOutput)output, SI_DOCCOUNT);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(si.getDocCount()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.write((DataOutput)output, SI_USECOMPOUND);
            SimpleTextUtil.write((DataOutput)output, Boolean.toString(si.getUseCompoundFile()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            Map diagnostics = si.getDiagnostics();
            int numDiagnostics = diagnostics == null ? 0 : diagnostics.size();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_DIAG);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(numDiagnostics), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            if (numDiagnostics > 0) {
                for (Map.Entry diagEntry : diagnostics.entrySet()) {
                    SimpleTextUtil.write((DataOutput)output, SI_DIAG_KEY);
                    SimpleTextUtil.write((DataOutput)output, (String)diagEntry.getKey(), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                    SimpleTextUtil.write((DataOutput)output, SI_DIAG_VALUE);
                    SimpleTextUtil.write((DataOutput)output, (String)diagEntry.getValue(), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                }
            }
            Map attributes = si.getAttributes();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_ATT);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(attributes.size()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            for (Map.Entry attEntry : attributes.entrySet()) {
                SimpleTextUtil.write((DataOutput)output, SI_ATT_KEY);
                SimpleTextUtil.write((DataOutput)output, (String)attEntry.getKey(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                SimpleTextUtil.write((DataOutput)output, SI_ATT_VALUE);
                SimpleTextUtil.write((DataOutput)output, (String)attEntry.getValue(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
            }
            Set files = si.files();
            int numFiles = files == null ? 0 : files.size();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_FILES);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(numFiles), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            if (numFiles > 0) {
                for (String fileName : files) {
                    SimpleTextUtil.write((DataOutput)output, SI_FILE);
                    SimpleTextUtil.write((DataOutput)output, fileName, scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                }
            }
            SimpleTextUtil.write((DataOutput)output, SI_ID);
            SimpleTextUtil.write((DataOutput)output, new BytesRef(si.getId()));
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.writeChecksum(output, scratch);
        }
    }
}

