/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class MemoryDocValuesProducer
extends DocValuesProducer {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, FSTEntry> fsts;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedNumericEntry> sortedNumerics;
    private final IndexInput data;
    private final Map<String, NumericDocValues> numericInstances;
    private final Map<String, BytesAndAddresses> pagedBytesInstances;
    private final Map<String, FST<Long>> fstInstances;
    private final Map<String, FixedBitSet> docsWithFieldInstances;
    private final Map<String, MonotonicBlockPackedReader> addresses;
    private final Map<String, Accountable> numericInfo;
    private final int numEntries;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final int version;
    private final boolean merging;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte FST = 2;
    static final byte SORTED_SET = 4;
    static final byte SORTED_SET_SINGLETON = 5;
    static final byte SORTED_NUMERIC = 6;
    static final byte SORTED_NUMERIC_SINGLETON = 7;
    static final int BLOCK_SIZE = 4096;
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte BLOCK_COMPRESSED = 2;
    static final byte GCD_COMPRESSED = 3;
    static final int VERSION_START = 4;
    static final int VERSION_CURRENT = 4;

    MemoryDocValuesProducer(MemoryDocValuesProducer original) throws IOException {
        this.numerics = new HashMap<String, NumericEntry>();
        this.binaries = new HashMap<String, BinaryEntry>();
        this.fsts = new HashMap<String, FSTEntry>();
        this.sortedSets = new HashMap<String, SortedSetEntry>();
        this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
        this.numericInstances = new HashMap<String, NumericDocValues>();
        this.pagedBytesInstances = new HashMap<String, BytesAndAddresses>();
        this.fstInstances = new HashMap<String, FST<Long>>();
        this.docsWithFieldInstances = new HashMap<String, FixedBitSet>();
        this.addresses = new HashMap<String, MonotonicBlockPackedReader>();
        this.numericInfo = new HashMap<String, Accountable>();
        assert (Thread.holdsLock((Object)original));
        this.numerics.putAll(original.numerics);
        this.binaries.putAll(original.binaries);
        this.fsts.putAll(original.fsts);
        this.sortedSets.putAll(original.sortedSets);
        this.sortedNumerics.putAll(original.sortedNumerics);
        this.data = original.data.clone();
        this.numericInstances.putAll(original.numericInstances);
        this.pagedBytesInstances.putAll(original.pagedBytesInstances);
        this.fstInstances.putAll(original.fstInstances);
        this.docsWithFieldInstances.putAll(original.docsWithFieldInstances);
        this.addresses.putAll(original.addresses);
        this.numericInfo.putAll(original.numericInfo);
        this.numEntries = original.numEntries;
        this.maxDoc = original.maxDoc;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.version = original.version;
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MemoryDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block8: {
            ChecksumIndexInput in;
            block7: {
                this.numerics = new HashMap<String, NumericEntry>();
                this.binaries = new HashMap<String, BinaryEntry>();
                this.fsts = new HashMap<String, FSTEntry>();
                this.sortedSets = new HashMap<String, SortedSetEntry>();
                this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
                this.numericInstances = new HashMap<String, NumericDocValues>();
                this.pagedBytesInstances = new HashMap<String, BytesAndAddresses>();
                this.fstInstances = new HashMap<String, FST<Long>>();
                this.docsWithFieldInstances = new HashMap<String, FixedBitSet>();
                this.addresses = new HashMap<String, MonotonicBlockPackedReader>();
                this.numericInfo = new HashMap<String, Accountable>();
                this.maxDoc = state.segmentInfo.getDocCount();
                this.merging = false;
                String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
                in = state.directory.openChecksumInput(metaName, state.context);
                success = false;
                try {
                    this.version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)4, (int)4, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.numEntries = this.readFields((IndexInput)in, state.fieldInfos);
                    CodecUtil.checkFooter((ChecksumIndexInput)in);
                    this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(((Object)((Object)this)).getClass()));
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block8;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)4, (int)4, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + this.version + ", data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
    }

    private NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.offset = meta.readLong();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.format = meta.readByte();
        switch (entry.format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format, (DataInput)meta);
            }
        }
        entry.packedIntsVersion = meta.readVInt();
        entry.count = meta.readLong();
        return entry;
    }

    private BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.offset = meta.readLong();
        entry.numBytes = meta.readLong();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        if (entry.minLength != entry.maxLength) {
            entry.packedIntsVersion = meta.readVInt();
            entry.blockSize = meta.readVInt();
        }
        return entry;
    }

    private FSTEntry readFSTEntry(IndexInput meta) throws IOException {
        FSTEntry entry = new FSTEntry();
        entry.offset = meta.readLong();
        entry.numOrds = meta.readVLong();
        return entry;
    }

    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numEntries = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            ++numEntries;
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("invalid field number: " + fieldNumber, (DataInput)meta);
            }
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                this.numerics.put(info.name, this.readNumericEntry(meta));
            } else if (fieldType == 1) {
                this.binaries.put(info.name, this.readBinaryEntry(meta));
            } else if (fieldType == 2) {
                this.fsts.put(info.name, this.readFSTEntry(meta));
            } else if (fieldType == 4) {
                entry = new SortedSetEntry();
                ((SortedSetEntry)entry).singleton = false;
                this.sortedSets.put(info.name, (SortedSetEntry)entry);
            } else if (fieldType == 5) {
                entry = new SortedSetEntry();
                ((SortedSetEntry)entry).singleton = true;
                this.sortedSets.put(info.name, (SortedSetEntry)entry);
            } else if (fieldType == 6) {
                entry = new SortedNumericEntry();
                ((SortedNumericEntry)entry).singleton = false;
                ((SortedNumericEntry)entry).packedIntsVersion = meta.readVInt();
                ((SortedNumericEntry)entry).blockSize = meta.readVInt();
                ((SortedNumericEntry)entry).addressOffset = meta.readLong();
                ((SortedNumericEntry)entry).valueCount = meta.readLong();
                this.sortedNumerics.put(info.name, (SortedNumericEntry)entry);
            } else if (fieldType == 7) {
                entry = new SortedNumericEntry();
                ((SortedNumericEntry)entry).singleton = true;
                this.sortedNumerics.put(info.name, (SortedNumericEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", fieldName=" + info.name, (DataInput)meta);
            }
            fieldNumber = meta.readVInt();
        }
        return numEntries;
    }

    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field.name);
        if (instance == null) {
            instance = this.loadNumeric(field);
            if (!this.merging) {
                this.numericInstances.put(field.name, instance);
            }
        }
        return instance;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    public synchronized Collection<Accountable> getChildResources() {
        ArrayList resources = new ArrayList();
        resources.addAll(Accountables.namedAccountables((String)"numeric field", this.numericInfo));
        resources.addAll(Accountables.namedAccountables((String)"pagedbytes field", this.pagedBytesInstances));
        resources.addAll(Accountables.namedAccountables((String)"term dict field", this.fstInstances));
        resources.addAll(Accountables.namedAccountables((String)"missing bitset field", this.docsWithFieldInstances));
        resources.addAll(Accountables.namedAccountables((String)"addresses field", this.addresses));
        return Collections.unmodifiableList(resources);
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new MemoryDocValuesProducer(this);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(entries=" + this.numEntries + ")";
    }

    private NumericDocValues loadNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        this.data.seek(entry.offset + entry.missingBytes);
        switch (entry.format) {
            case 1: {
                int size = this.data.readVInt();
                if (size > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + size, (DataInput)this.data);
                }
                final long[] decode = new long[size];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader((DataInput)this.data, (PackedInts.Format)PackedInts.Format.byId((int)formatID), (int)entry.packedIntsVersion, (int)((int)entry.count), (int)bitsPerValue);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((long[])decode) + ordsReader.ramBytesUsed());
                    this.numericInfo.put(field.name, Accountables.namedAccountable((String)"table compressed", (Accountable)ordsReader));
                }
                return new NumericDocValues(){

                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
            case 0: {
                final long minDelta = this.data.readLong();
                int formatIDDelta = this.data.readVInt();
                int bitsPerValueDelta = this.data.readVInt();
                final PackedInts.Reader deltaReader = PackedInts.getReaderNoHeader((DataInput)this.data, (PackedInts.Format)PackedInts.Format.byId((int)formatIDDelta), (int)entry.packedIntsVersion, (int)((int)entry.count), (int)bitsPerValueDelta);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(deltaReader.ramBytesUsed());
                    this.numericInfo.put(field.name, Accountables.namedAccountable((String)"delta compressed", (Accountable)deltaReader));
                }
                return new NumericDocValues(){

                    public long get(int docID) {
                        return minDelta + deltaReader.get(docID);
                    }
                };
            }
            case 2: {
                int blockSize = this.data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(this.data, entry.packedIntsVersion, blockSize, entry.count, false);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
                    this.numericInfo.put(field.name, Accountables.namedAccountable((String)"block compressed", (Accountable)reader));
                }
                return reader;
            }
            case 3: {
                final long min = this.data.readLong();
                final long mult = this.data.readLong();
                int formatIDGCD = this.data.readVInt();
                int bitsPerValueGCD = this.data.readVInt();
                final PackedInts.Reader quotientReader = PackedInts.getReaderNoHeader((DataInput)this.data, (PackedInts.Format)PackedInts.Format.byId((int)formatIDGCD), (int)entry.packedIntsVersion, (int)((int)entry.count), (int)bitsPerValueGCD);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(quotientReader.ramBytesUsed());
                    this.numericInfo.put(field.name, Accountables.namedAccountable((String)"gcd compressed", (Accountable)quotientReader));
                }
                return new NumericDocValues(){

                    public long get(int docID) {
                        return min + mult * quotientReader.get(docID);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BytesAndAddresses instance;
        BinaryEntry entry = this.binaries.get(field.name);
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.pagedBytesInstances.get(field.name);
            if (instance == null) {
                instance = this.loadBinary(field);
                if (!this.merging) {
                    this.pagedBytesInstances.put(field.name, instance);
                }
            }
        }
        final PagedBytes.Reader bytesReader = instance.reader;
        final MonotonicBlockPackedReader addresses = instance.addresses;
        if (addresses == null) {
            assert (entry.minLength == entry.maxLength);
            final int fixedLength = entry.minLength;
            return new BinaryDocValues(){
                final BytesRef term = new BytesRef();

                public BytesRef get(int docID) {
                    bytesReader.fillSlice(this.term, (long)fixedLength * (long)docID, fixedLength);
                    return this.term;
                }
            };
        }
        return new BinaryDocValues(){
            final BytesRef term = new BytesRef();

            public BytesRef get(int docID) {
                long startAddress = docID == 0 ? 0L : addresses.get(docID - 1);
                long endAddress = addresses.get(docID);
                bytesReader.fillSlice(this.term, startAddress, (int)(endAddress - startAddress));
                return this.term;
            }
        };
    }

    private BytesAndAddresses loadBinary(FieldInfo field) throws IOException {
        BytesAndAddresses bytesAndAddresses = new BytesAndAddresses();
        BinaryEntry entry = this.binaries.get(field.name);
        this.data.seek(entry.offset);
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(this.data, entry.numBytes);
        bytesAndAddresses.reader = bytes.freeze(true);
        if (!this.merging) {
            this.ramBytesUsed.addAndGet(bytesAndAddresses.reader.ramBytesUsed());
        }
        if (entry.minLength != entry.maxLength) {
            this.data.seek(this.data.getFilePointer() + entry.missingBytes);
            bytesAndAddresses.addresses = MonotonicBlockPackedReader.of((IndexInput)this.data, (int)entry.packedIntsVersion, (int)entry.blockSize, (long)this.maxDoc, (boolean)false);
            if (!this.merging) {
                this.ramBytesUsed.addAndGet(bytesAndAddresses.addresses.ramBytesUsed());
            }
        }
        return bytesAndAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        FST instance;
        final FSTEntry entry = this.fsts.get(field.name);
        if (entry.numOrds == 0L) {
            return DocValues.emptySorted();
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field.name);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST((DataInput)this.data, (Outputs)PositiveIntOutputs.getSingleton());
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                    this.fstInstances.put(field.name, (FST<Long>)instance);
                }
            }
        }
        final NumericDocValues docToOrd = this.getNumeric(field);
        final FST fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(fst);
        return new SortedDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();

            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            public BytesRef lookupOrd(int ord) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput((FST)fst, (long)ord, (FST.BytesReader)in, (FST.Arc)firstArc, (FST.Arc)scratchArc, (IntsRefBuilder)scratchInts);
                    return Util.toBytesRef((IntsRef)output, (BytesRefBuilder)this.term);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public int lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1;
                    }
                    if (o.input.equals((Object)key)) {
                        return ((Long)o.output).intValue();
                    }
                    return (int)(-((Long)o.output).longValue()) - 1;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public int getValueCount() {
                return (int)entry.numOrds;
            }

            public TermsEnum termsEnum() {
                return new FSTTermsEnum((FST<Long>)fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        MonotonicBlockPackedReader addr;
        SortedNumericEntry entry = this.sortedNumerics.get(field.name);
        if (entry.singleton) {
            NumericDocValues values = this.getNumeric(field);
            NumericEntry ne = this.numerics.get(field.name);
            Bits docsWithField = this.getMissingBits(field, ne.missingOffset, ne.missingBytes);
            return DocValues.singleton((NumericDocValues)values, (Bits)docsWithField);
        }
        final NumericDocValues values = this.getNumeric(field);
        MemoryDocValuesProducer docsWithField = this;
        synchronized (docsWithField) {
            MonotonicBlockPackedReader res = this.addresses.get(field.name);
            if (res == null) {
                this.data.seek(entry.addressOffset);
                res = MonotonicBlockPackedReader.of((IndexInput)this.data, (int)entry.packedIntsVersion, (int)entry.blockSize, (long)entry.valueCount, (boolean)false);
                if (!this.merging) {
                    this.addresses.put(field.name, res);
                    this.ramBytesUsed.addAndGet(res.ramBytesUsed());
                }
            }
            addr = res;
        }
        if (values instanceof LongValues) {
            final LongValues longValues = (LongValues)values;
            return new SortedNumericDocValues(){
                long startOffset;
                long endOffset;

                public void setDocument(int doc) {
                    this.startOffset = (int)addr.get(doc);
                    this.endOffset = (int)addr.get((long)doc + 1L);
                }

                public long valueAt(int index) {
                    return longValues.get(this.startOffset + (long)index);
                }

                public int count() {
                    return (int)(this.endOffset - this.startOffset);
                }
            };
        }
        return new SortedNumericDocValues(){
            int startOffset;
            int endOffset;

            public void setDocument(int doc) {
                this.startOffset = (int)addr.get(doc);
                this.endOffset = (int)addr.get(doc + 1);
            }

            public long valueAt(int index) {
                return values.get(this.startOffset + index);
            }

            public int count() {
                return this.endOffset - this.startOffset;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        FST instance;
        SortedSetEntry sortedSetEntry = this.sortedSets.get(field.name);
        if (sortedSetEntry.singleton) {
            return DocValues.singleton((SortedDocValues)this.getSorted(field));
        }
        final FSTEntry entry = this.fsts.get(field.name);
        if (entry.numOrds == 0L) {
            return DocValues.emptySortedSet();
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field.name);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST((DataInput)this.data, (Outputs)PositiveIntOutputs.getSingleton());
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                    this.fstInstances.put(field.name, (FST<Long>)instance);
                }
            }
        }
        final BinaryDocValues docToOrds = this.getBinary(field);
        final FST fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(fst);
        final ByteArrayDataInput input = new ByteArrayDataInput();
        return new SortedSetDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();
            BytesRef ref;
            long currentOrd;

            public long nextOrd() {
                if (input.eof()) {
                    return -1L;
                }
                this.currentOrd += input.readVLong();
                return this.currentOrd;
            }

            public void setDocument(int docID) {
                this.ref = docToOrds.get(docID);
                input.reset(this.ref.bytes, this.ref.offset, this.ref.length);
                this.currentOrd = 0L;
            }

            public BytesRef lookupOrd(long ord) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput((FST)fst, (long)ord, (FST.BytesReader)in, (FST.Arc)firstArc, (FST.Arc)scratchArc, (IntsRefBuilder)scratchInts);
                    return Util.toBytesRef((IntsRef)output, (BytesRefBuilder)this.term);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public long lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1L;
                    }
                    if (o.input.equals((Object)key)) {
                        return ((Long)o.output).intValue();
                    }
                    return -((Long)o.output).longValue() - 1L;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public long getValueCount() {
                return entry.numOrds;
            }

            public TermsEnum termsEnum() {
                return new FSTTermsEnum((FST<Long>)fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(FieldInfo field, long offset, long length) throws IOException {
        FixedBitSet instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(field.name);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(offset);
                assert (length % 8L == 0L);
                long[] bits = new long[(int)length >> 3];
                for (int i = 0; i < bits.length; ++i) {
                    bits[i] = data.readLong();
                }
                instance = new FixedBitSet(bits, this.maxDoc);
                if (!this.merging) {
                    this.docsWithFieldInstances.put(field.name, instance);
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                }
            }
        }
        return instance;
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue((SortedSetDocValues)this.getSortedSet(field), (int)this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue((SortedNumericDocValues)this.getSortedNumeric(field), (int)this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue((SortedDocValues)this.getSorted(field), (int)this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.name);
                return this.getMissingBits(field, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.name);
                return this.getMissingBits(field, ne.missingOffset, ne.missingBytes);
            }
        }
        throw new AssertionError();
    }

    public void close() throws IOException {
        this.data.close();
    }

    static class FSTTermsEnum
    extends TermsEnum {
        final BytesRefFSTEnum<Long> in;
        final FST<Long> fst;
        final FST.BytesReader bytesReader;
        final FST.Arc<Long> firstArc = new FST.Arc();
        final FST.Arc<Long> scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefBuilder scratchBytes = new BytesRefBuilder();

        FSTTermsEnum(FST<Long> fst) {
            this.fst = fst;
            this.in = new BytesRefFSTEnum(fst);
            this.bytesReader = fst.getBytesReader();
        }

        public BytesRef next() throws IOException {
            BytesRefFSTEnum.InputOutput io = this.in.next();
            if (io == null) {
                return null;
            }
            return io.input;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            if (this.in.seekCeil(text) == null) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.term().equals((Object)text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public boolean seekExact(BytesRef text) throws IOException {
            return this.in.seekExact(text) != null;
        }

        public void seekExact(long ord) throws IOException {
            this.bytesReader.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            IntsRef output = Util.getByOutput(this.fst, (long)ord, (FST.BytesReader)this.bytesReader, this.firstArc, this.scratchArc, (IntsRefBuilder)this.scratchInts);
            this.in.seekExact(Util.toBytesRef((IntsRef)output, (BytesRefBuilder)new BytesRefBuilder()));
        }

        public BytesRef term() throws IOException {
            return this.in.current().input;
        }

        public long ord() throws IOException {
            return (Long)this.in.current().output;
        }

        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class BytesAndAddresses
    implements Accountable {
        PagedBytes.Reader reader;
        MonotonicBlockPackedReader addresses;

        BytesAndAddresses() {
        }

        public long ramBytesUsed() {
            long bytesUsed = this.reader.ramBytesUsed();
            if (this.addresses != null) {
                bytesUsed += this.addresses.ramBytesUsed();
            }
            return bytesUsed;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            if (this.addresses != null) {
                resources.add(Accountables.namedAccountable((String)"addresses", (Accountable)this.addresses));
            }
            resources.add(Accountables.namedAccountable((String)"term bytes", (Accountable)this.reader));
            return Collections.unmodifiableList(resources);
        }
    }

    static class SortedNumericEntry {
        boolean singleton;
        long addressOffset;
        int packedIntsVersion;
        int blockSize;
        long valueCount;

        SortedNumericEntry() {
        }
    }

    static class SortedSetEntry {
        boolean singleton;

        SortedSetEntry() {
        }
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        long numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        long count;
        long missingOffset;
        long missingBytes;
        byte format;
        int packedIntsVersion;

        NumericEntry() {
        }
    }
}

