/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktreeords;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.blocktreeords.FSTOrdsOutputs;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsWriter;
import org.apache.lucene.codecs.blocktreeords.OrdsFieldReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class OrdsBlockTreeTermsReader
extends FieldsProducer {
    final IndexInput in;
    final PostingsReaderBase postingsReader;
    private final TreeMap<String, OrdsFieldReader> fields = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OrdsBlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        this.postingsReader = postingsReader;
        String termsFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"tio");
        this.in = state.directory.openInput(termsFile, state.context);
        boolean success = false;
        IndexInput indexIn = null;
        try {
            int version = CodecUtil.checkIndexHeader((DataInput)this.in, (String)"OrdsBlockTreeTerms", (int)1, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            String indexFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"tipo");
            indexIn = state.directory.openInput(indexFile, state.context);
            int indexVersion = CodecUtil.checkIndexHeader((DataInput)indexIn, (String)"OrdsBlockTreeIndex", (int)1, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (indexVersion != version) {
                throw new CorruptIndexException("mixmatched version files: " + this.in + "=" + version + "," + indexIn + "=" + indexVersion, (DataInput)indexIn);
            }
            CodecUtil.checksumEntireFile((IndexInput)indexIn);
            postingsReader.init(this.in, state);
            CodecUtil.retrieveChecksum((IndexInput)this.in);
            this.seekDir(this.in);
            this.seekDir(indexIn);
            int numFields = this.in.readVInt();
            if (numFields < 0) {
                throw new CorruptIndexException("invalid numFields: " + numFields, (DataInput)this.in);
            }
            for (int i = 0; i < numFields; ++i) {
                int field = this.in.readVInt();
                long numTerms = this.in.readVLong();
                assert (numTerms >= 0L);
                int numBytes = this.in.readVInt();
                BytesRef code = new BytesRef(new byte[numBytes]);
                this.in.readBytes(code.bytes, 0, numBytes);
                code.length = numBytes;
                FSTOrdsOutputs.Output rootCode = OrdsBlockTreeTermsWriter.FST_OUTPUTS.newOutput(code, 0L, numTerms);
                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                assert (fieldInfo != null) : "field=" + field;
                assert (numTerms <= Integer.MAX_VALUE);
                long sumTotalTermFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? -1L : this.in.readVLong();
                long sumDocFreq = this.in.readVLong();
                int docCount = this.in.readVInt();
                int longsSize = this.in.readVInt();
                BytesRef minTerm = OrdsBlockTreeTermsReader.readBytesRef(this.in);
                BytesRef maxTerm = OrdsBlockTreeTermsReader.readBytesRef(this.in);
                if (docCount < 0 || docCount > state.segmentInfo.getDocCount()) {
                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.getDocCount(), (DataInput)this.in);
                }
                if (sumDocFreq < (long)docCount) {
                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, (DataInput)this.in);
                }
                if (sumTotalTermFreq != -1L && sumTotalTermFreq < sumDocFreq) {
                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, (DataInput)this.in);
                }
                long indexStartFP = indexIn.readVLong();
                OrdsFieldReader previous = this.fields.put(fieldInfo.name, new OrdsFieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, longsSize, indexIn, minTerm, maxTerm));
                if (previous == null) continue;
                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, (DataInput)this.in);
            }
            indexIn.close();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexIn, this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        BytesRef bytes = new BytesRef();
        bytes.length = in.readVInt();
        bytes.bytes = new byte[bytes.length];
        in.readBytes(bytes.bytes, 0, bytes.length);
        return bytes;
    }

    private void seekDir(IndexInput input) throws IOException {
        input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
        long dirOffset = input.readLong();
        input.seek(dirOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.in, this.postingsReader});
        }
        finally {
            this.fields.clear();
        }
    }

    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fields.get(field);
    }

    public int size() {
        return this.fields.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    public long ramBytesUsed() {
        long sizeInBytes = this.postingsReader.ramBytesUsed();
        for (OrdsFieldReader reader : this.fields.values()) {
            sizeInBytes += reader.ramBytesUsed();
        }
        return sizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.addAll(Accountables.namedAccountables((String)"field", this.fields));
        resources.add(Accountables.namedAccountable((String)"delegate", (Accountable)this.postingsReader));
        return Collections.unmodifiableList(resources);
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.in);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.fields.size() + ",delegate=" + this.postingsReader.toString() + ")";
    }
}

