/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.intblock;

import java.io.IOException;
import org.apache.lucene.codecs.sep.IntIndexOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;

public abstract class VariableIntBlockIndexOutput
extends IntIndexOutput {
    protected final IndexOutput out;
    private int upto;
    private boolean hitExcDuringWrite;

    protected VariableIntBlockIndexOutput(IndexOutput out, int maxBlockSize) throws IOException {
        this.out = out;
        out.writeInt(maxBlockSize);
    }

    protected abstract int add(int var1) throws IOException;

    @Override
    public IntIndexOutput.Index index() {
        return new Index();
    }

    @Override
    public void write(int v) throws IOException {
        this.hitExcDuringWrite = true;
        this.upto -= this.add(v) - 1;
        this.hitExcDuringWrite = false;
        assert (this.upto >= 0);
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.hitExcDuringWrite) {
                for (int stuffed = 0; this.upto > stuffed; ++stuffed) {
                    this.upto -= this.add(0) - 1;
                    assert (this.upto >= 0);
                }
            }
        }
        finally {
            this.out.close();
        }
    }

    private class Index
    extends IntIndexOutput.Index {
        long fp;
        int upto;
        long lastFP;
        int lastUpto;

        private Index() {
        }

        @Override
        public void mark() throws IOException {
            this.fp = VariableIntBlockIndexOutput.this.out.getFilePointer();
            this.upto = VariableIntBlockIndexOutput.this.upto;
        }

        @Override
        public void copyFrom(IntIndexOutput.Index other, boolean copyLast) throws IOException {
            Index idx = (Index)other;
            this.fp = idx.fp;
            this.upto = idx.upto;
            if (copyLast) {
                this.lastFP = this.fp;
                this.lastUpto = this.upto;
            }
        }

        @Override
        public void write(DataOutput indexOut, boolean absolute) throws IOException {
            assert (this.upto >= 0);
            if (absolute) {
                indexOut.writeVInt(this.upto);
                indexOut.writeVLong(this.fp);
            } else if (this.fp == this.lastFP) {
                assert (this.upto >= this.lastUpto);
                int uptoDelta = this.upto - this.lastUpto;
                indexOut.writeVInt(uptoDelta << 1 | 1);
            } else {
                indexOut.writeVInt(this.upto << 1);
                indexOut.writeVLong(this.fp - this.lastFP);
            }
            this.lastUpto = this.upto;
            this.lastFP = this.fp;
        }
    }
}

