/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.classification;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.classification.ClassificationResult;
import org.apache.lucene.classification.Classifier;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;

public class KNearestNeighborClassifier
implements Classifier<BytesRef> {
    private MoreLikeThis mlt;
    private String textFieldName;
    private String classFieldName;
    private IndexSearcher indexSearcher;
    private int k;

    public KNearestNeighborClassifier(int k) {
        this.k = k;
    }

    @Override
    public ClassificationResult<BytesRef> assignClass(String text) throws IOException {
        if (this.mlt == null) {
            throw new IOException("You must first call Classifier#train first");
        }
        Query q = this.mlt.like((Reader)new StringReader(text), this.textFieldName);
        TopDocs topDocs = this.indexSearcher.search(q, this.k);
        return this.selectClassFromNeighbors(topDocs);
    }

    private ClassificationResult<BytesRef> selectClassFromNeighbors(TopDocs topDocs) throws IOException {
        Integer count;
        HashMap<BytesRef, Integer> classCounts = new HashMap<BytesRef, Integer>();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            BytesRef cl = new BytesRef((CharSequence)this.indexSearcher.doc(scoreDoc.doc).getField(this.classFieldName).stringValue());
            if (cl == null) continue;
            count = (Integer)classCounts.get(cl);
            if (count != null) {
                classCounts.put(cl, count + 1);
                continue;
            }
            classCounts.put(cl, 1);
        }
        double max = 0.0;
        BytesRef assignedClass = new BytesRef();
        for (BytesRef cl : classCounts.keySet()) {
            count = (Integer)classCounts.get(cl);
            if (!((double)count.intValue() > max)) continue;
            max = count.intValue();
            assignedClass = cl.clone();
        }
        double score = max / (double)this.k;
        return new ClassificationResult<BytesRef>(assignedClass, score);
    }

    @Override
    public void train(AtomicReader atomicReader, String textFieldName, String classFieldName, Analyzer analyzer) throws IOException {
        this.textFieldName = textFieldName;
        this.classFieldName = classFieldName;
        this.mlt = new MoreLikeThis((IndexReader)atomicReader);
        this.mlt.setAnalyzer(analyzer);
        this.mlt.setFieldNames(new String[]{textFieldName});
        this.indexSearcher = new IndexSearcher((IndexReader)atomicReader);
    }
}

