/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.BenchmarkHighlighter;
import org.apache.lucene.benchmark.byTask.tasks.SearchTravTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;

public class SearchTravRetHighlightTask
extends SearchTravTask {
    protected int numToHighlight = Integer.MAX_VALUE;
    protected boolean mergeContiguous;
    protected int maxFrags = 2;
    protected Set<String> paramFields = Collections.emptySet();
    protected Highlighter highlighter;
    protected int maxDocCharsToAnalyze;

    public SearchTravRetHighlightTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        PerfRunData data = this.getRunData();
        if (!data.getConfig().get("doc.stored", false)) {
            throw new Exception("doc.stored must be set to true");
        }
        this.maxDocCharsToAnalyze = data.getConfig().get("highlighter.maxDocCharsToAnalyze", 51200);
    }

    @Override
    public boolean withRetrieve() {
        return true;
    }

    @Override
    public int numToHighlight() {
        return this.numToHighlight;
    }

    @Override
    protected BenchmarkHighlighter getBenchmarkHighlighter(Query q) {
        this.highlighter = new Highlighter((Formatter)new SimpleHTMLFormatter(), (Scorer)new QueryScorer(q));
        this.highlighter.setMaxDocCharsToAnalyze(this.maxDocCharsToAnalyze);
        return new BenchmarkHighlighter(){

            @Override
            public int doHighlight(IndexReader reader, int doc, String field, Document document, Analyzer analyzer, String text) throws Exception {
                int maxStartOffset = SearchTravRetHighlightTask.this.highlighter.getMaxDocCharsToAnalyze() - 1;
                TokenStream ts = TokenSources.getTokenStream((String)field, (Fields)reader.getTermVectors(doc), (String)text, (Analyzer)analyzer, (int)maxStartOffset);
                TextFragment[] frag = SearchTravRetHighlightTask.this.highlighter.getBestTextFragments(ts, text, SearchTravRetHighlightTask.this.mergeContiguous, SearchTravRetHighlightTask.this.maxFrags);
                return frag != null ? frag.length : 0;
            }
        };
    }

    @Override
    protected Collection<String> getFieldsToHighlight(Document document) {
        Collection<String> result = super.getFieldsToHighlight(document);
        if (!this.paramFields.isEmpty() && !result.isEmpty()) {
            result.retainAll(this.paramFields);
        } else {
            result = this.paramFields;
        }
        return result;
    }

    @Override
    public void setParams(String params) {
        this.params = params;
        String[] splits = params.split(",");
        for (int i = 0; i < splits.length; ++i) {
            if (splits[i].startsWith("size[")) {
                this.traversalSize = (int)Float.parseFloat(splits[i].substring("size[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("highlight[")) {
                this.numToHighlight = (int)Float.parseFloat(splits[i].substring("highlight[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("maxFrags[")) {
                this.maxFrags = (int)Float.parseFloat(splits[i].substring("maxFrags[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("mergeContiguous[")) {
                this.mergeContiguous = Boolean.valueOf(splits[i].substring("mergeContiguous[".length(), splits[i].length() - 1));
                continue;
            }
            if (!splits[i].startsWith("fields[")) continue;
            this.paramFields = new HashSet<String>();
            String fieldNames = splits[i].substring("fields[".length(), splits[i].length() - 1);
            String[] fieldSplits = fieldNames.split(";");
            for (int j = 0; j < fieldSplits.length; ++j) {
                this.paramFields.add(fieldSplits[j]);
            }
        }
    }
}

