/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.NoDeletionPolicy;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.NoMergeScheduler;
import org.apache.lucene.util.Version;

public class CreateIndexTask
extends PerfTask {
    public CreateIndexTask(PerfRunData runData) {
        super(runData);
    }

    public static IndexDeletionPolicy getIndexDeletionPolicy(Config config) {
        String deletionPolicyName = config.get("deletion.policy", "org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy");
        if (deletionPolicyName.equals(NoDeletionPolicy.class.getName())) {
            return NoDeletionPolicy.INSTANCE;
        }
        try {
            return Class.forName(deletionPolicyName).asSubclass(IndexDeletionPolicy.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate class '" + deletionPolicyName + "' as IndexDeletionPolicy", e);
        }
    }

    @Override
    public int doLogic() throws IOException {
        PerfRunData runData = this.getRunData();
        Config config = runData.getConfig();
        runData.setIndexWriter(CreateIndexTask.configureWriter(config, runData, IndexWriterConfig.OpenMode.CREATE, null));
        return 1;
    }

    public static IndexWriterConfig createWriterConfig(Config config, PerfRunData runData, IndexWriterConfig.OpenMode mode, IndexCommit commit) {
        String mergeScheduler;
        Version version = Version.valueOf((String)config.get("writer.version", Version.LUCENE_47.toString()));
        IndexWriterConfig iwConf = new IndexWriterConfig(version, runData.getAnalyzer());
        iwConf.setOpenMode(mode);
        IndexDeletionPolicy indexDeletionPolicy = CreateIndexTask.getIndexDeletionPolicy(config);
        iwConf.setIndexDeletionPolicy(indexDeletionPolicy);
        if (commit != null) {
            iwConf.setIndexCommit(commit);
        }
        if ((mergeScheduler = config.get("merge.scheduler", "org.apache.lucene.index.ConcurrentMergeScheduler")).equals(NoMergeScheduler.class.getName())) {
            iwConf.setMergeScheduler(NoMergeScheduler.INSTANCE);
        } else {
            try {
                iwConf.setMergeScheduler(Class.forName(mergeScheduler).asSubclass(MergeScheduler.class).newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("unable to instantiate class '" + mergeScheduler + "' as merge scheduler", e);
            }
            if (mergeScheduler.equals("org.apache.lucene.index.ConcurrentMergeScheduler")) {
                ConcurrentMergeScheduler cms = (ConcurrentMergeScheduler)iwConf.getMergeScheduler();
                int maxThreadCount = config.get("concurrent.merge.scheduler.max.thread.count", 1);
                int maxMergeCount = config.get("concurrent.merge.scheduler.max.merge.count", 2);
                cms.setMaxMergesAndThreads(maxMergeCount, maxThreadCount);
            }
        }
        String defaultCodec = config.get("default.codec", null);
        if (defaultCodec != null) {
            try {
                Class<Codec> clazz = Class.forName(defaultCodec).asSubclass(Codec.class);
                Codec.setDefault((Codec)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't instantiate Codec: " + defaultCodec, e);
            }
        }
        String mergePolicy = config.get("merge.policy", "org.apache.lucene.index.LogByteSizeMergePolicy");
        boolean isCompound = config.get("compound", true);
        if (mergePolicy.equals(NoMergePolicy.class.getName())) {
            iwConf.setMergePolicy(isCompound ? NoMergePolicy.COMPOUND_FILES : NoMergePolicy.NO_COMPOUND_FILES);
        } else {
            try {
                iwConf.setMergePolicy(Class.forName(mergePolicy).asSubclass(MergePolicy.class).newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("unable to instantiate class '" + mergePolicy + "' as merge policy", e);
            }
            iwConf.getMergePolicy().setNoCFSRatio(isCompound ? 1.0 : 0.0);
            if (iwConf.getMergePolicy() instanceof LogMergePolicy) {
                LogMergePolicy logMergePolicy = (LogMergePolicy)iwConf.getMergePolicy();
                logMergePolicy.setMergeFactor(config.get("merge.factor", 10));
            }
        }
        double ramBuffer = config.get("ram.flush.mb", 16.0);
        int maxBuffered = config.get("max.buffered", -1);
        if (maxBuffered == -1) {
            iwConf.setRAMBufferSizeMB(ramBuffer);
            iwConf.setMaxBufferedDocs(maxBuffered);
        } else {
            iwConf.setMaxBufferedDocs(maxBuffered);
            iwConf.setRAMBufferSizeMB(ramBuffer);
        }
        return iwConf;
    }

    public static IndexWriter configureWriter(Config config, PerfRunData runData, IndexWriterConfig.OpenMode mode, IndexCommit commit) throws IOException {
        IndexWriterConfig iwc = CreateIndexTask.createWriterConfig(config, runData, mode, commit);
        String infoStreamVal = config.get("writer.info.stream", null);
        if (infoStreamVal != null) {
            if (infoStreamVal.equals("SystemOut")) {
                iwc.setInfoStream(System.out);
            } else if (infoStreamVal.equals("SystemErr")) {
                iwc.setInfoStream(System.err);
            } else {
                File f = new File(infoStreamVal).getAbsoluteFile();
                iwc.setInfoStream(new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(f)), false, Charset.defaultCharset().name()));
            }
        }
        IndexWriter writer = new IndexWriter(runData.getDirectory(), iwc);
        return writer;
    }
}

