/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;

public class NewLocaleTask
extends PerfTask {
    private String language;
    private String country;
    private String variant;

    public NewLocaleTask(PerfRunData runData) {
        super(runData);
    }

    static Locale createLocale(String language, String country, String variant) {
        if (language == null || language.length() == 0) {
            return null;
        }
        String lang = language;
        if (lang.equalsIgnoreCase("ROOT")) {
            lang = "";
        }
        return new Locale(lang, country, variant);
    }

    @Override
    public int doLogic() throws Exception {
        Locale locale = NewLocaleTask.createLocale(this.language, this.country, this.variant);
        this.getRunData().setLocale(locale);
        System.out.println("Changed Locale to: " + (locale == null ? "null" : (locale.getDisplayName().length() == 0 ? "root locale" : locale)));
        return 1;
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        this.variant = "";
        this.country = "";
        this.language = "";
        StringTokenizer st = new StringTokenizer(params, ",");
        if (st.hasMoreTokens()) {
            this.language = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.country = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.variant = st.nextToken();
        }
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

