/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.FacetSource;
import org.apache.lucene.benchmark.byTask.tasks.AddDocTask;
import org.apache.lucene.facet.index.FacetFields;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class AddFacetedDocTask
extends AddDocTask {
    private final List<CategoryPath> facets = new ArrayList<CategoryPath>();
    private FacetFields facetFields;

    public AddFacetedDocTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        boolean withFacets;
        super.setup();
        if (this.facetFields == null && (withFacets = this.getRunData().getConfig().get("with.facets", true))) {
            FacetSource facetsSource = this.getRunData().getFacetSource();
            this.facetFields = withFacets ? new FacetFields(this.getRunData().getTaxonomyWriter()) : null;
            facetsSource.getNextFacets(this.facets);
        }
    }

    @Override
    protected String getLogMessage(int recsCount) {
        if (this.facetFields == null) {
            return super.getLogMessage(recsCount);
        }
        return super.getLogMessage(recsCount) + " with facets";
    }

    @Override
    public int doLogic() throws Exception {
        if (this.facetFields != null) {
            this.facetFields.addFields(this.doc, this.facets);
        }
        return super.doLogic();
    }
}

