/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.StreamUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class WriteLineDocTask
extends PerfTask {
    public static final String FIELDS_HEADER_INDICATOR = "FIELDS_HEADER_INDICATOR###";
    public static final char SEP = '\t';
    public static final String[] DEFAULT_FIELDS = new String[]{"doctitle", "docdate", "body"};
    public static final String DEFAULT_SUFFICIENT_FIELDS = "doctitle,body";
    private int docSize = 0;
    private PrintWriter lineFileOut = null;
    private DocMaker docMaker;
    private ThreadLocal<StringBuilder> threadBuffer = new ThreadLocal();
    private ThreadLocal<Matcher> threadNormalizer = new ThreadLocal();
    private final String[] fieldsToWrite;
    private final boolean[] sufficientFields;
    private final boolean checkSufficientFields;

    public WriteLineDocTask(PerfRunData runData) throws Exception {
        super(runData);
        Config config = runData.getConfig();
        String fname = config.get("line.file.out", null);
        if (fname == null) {
            throw new IllegalArgumentException("line.file.out must be set");
        }
        OutputStream out = StreamUtils.outputStream(new File(fname));
        this.lineFileOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, "UTF-8"), 65536));
        this.docMaker = runData.getDocMaker();
        String f2r = config.get("line.fields", null);
        if (f2r == null) {
            this.fieldsToWrite = DEFAULT_FIELDS;
        } else {
            if (f2r.indexOf(9) >= 0) {
                throw new IllegalArgumentException("line.fields " + f2r + " should not contain the separator char: " + '\t');
            }
            this.fieldsToWrite = f2r.split(",");
        }
        this.sufficientFields = new boolean[this.fieldsToWrite.length];
        String suff = config.get("sufficient.fields", DEFAULT_SUFFICIENT_FIELDS);
        if (",".equals(suff)) {
            this.checkSufficientFields = false;
        } else {
            this.checkSufficientFields = true;
            HashSet<String> sf = new HashSet<String>(Arrays.asList(suff.split(",")));
            for (int i = 0; i < this.fieldsToWrite.length; ++i) {
                if (!sf.contains(this.fieldsToWrite[i])) continue;
                this.sufficientFields[i] = true;
            }
        }
        this.writeHeader();
    }

    private void writeHeader() {
        StringBuilder sb = this.threadBuffer.get();
        if (sb == null) {
            sb = new StringBuilder();
            this.threadBuffer.set(sb);
        }
        sb.setLength(0);
        sb.append(FIELDS_HEADER_INDICATOR);
        for (String f : this.fieldsToWrite) {
            sb.append('\t').append(f);
        }
        this.lineFileOut.println(sb.toString());
    }

    protected String getLogMessage(int recsCount) {
        return "Wrote " + recsCount + " line docs";
    }

    public int doLogic() throws Exception {
        StringBuilder sb;
        Document doc = this.docSize > 0 ? this.docMaker.makeDocument(this.docSize) : this.docMaker.makeDocument();
        Matcher matcher = this.threadNormalizer.get();
        if (matcher == null) {
            matcher = Pattern.compile("[\t\r\n]+").matcher("");
            this.threadNormalizer.set(matcher);
        }
        if ((sb = this.threadBuffer.get()) == null) {
            sb = new StringBuilder();
            this.threadBuffer.set(sb);
        }
        sb.setLength(0);
        boolean sufficient = !this.checkSufficientFields;
        for (int i = 0; i < this.fieldsToWrite.length; ++i) {
            Field f = doc.getField(this.fieldsToWrite[i]);
            String text = f == null ? "" : matcher.reset(f.stringValue()).replaceAll(" ").trim();
            sb.append(text).append('\t');
            sufficient |= text.length() > 0 && this.sufficientFields[i];
        }
        if (sufficient) {
            sb.setLength(sb.length() - 1);
            this.lineFileOut.println(sb.toString());
        }
        return 1;
    }

    public void close() throws Exception {
        this.lineFileOut.close();
        super.close();
    }

    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    public boolean supportsParams() {
        return true;
    }
}

