/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;

public class AddDocTask
extends PerfTask {
    private int docSize = 0;
    private Document doc = null;

    public AddDocTask(PerfRunData runData) {
        super(runData);
    }

    public void setup() throws Exception {
        super.setup();
        DocMaker docMaker = this.getRunData().getDocMaker();
        this.doc = this.docSize > 0 ? docMaker.makeDocument(this.docSize) : docMaker.makeDocument();
    }

    public void tearDown() throws Exception {
        this.doc = null;
        super.tearDown();
    }

    protected String getLogMessage(int recsCount) {
        return "added " + recsCount + " docs";
    }

    public int doLogic() throws Exception {
        this.getRunData().getIndexWriter().addDocument(this.doc);
        return 1;
    }

    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    public boolean supportsParams() {
        return true;
    }
}

