/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.HTMLParser;
import org.apache.lucene.benchmark.byTask.feeds.TrecContentSource;
import org.apache.lucene.benchmark.byTask.feeds.TrecDocParser;

public class TrecGov2Parser
extends TrecDocParser {
    private static final String DATE = "Date: ";
    private static final String DATE_END = TrecContentSource.NEW_LINE;
    private static final String DOCHDR = "<DOCHDR>";
    private static final String TERMINATING_DOCHDR = "</DOCHDR>";
    private static final int TERMINATING_DOCHDR_LENGTH = "</DOCHDR>".length();

    public DocData parse(DocData docData, String name, TrecContentSource trecSrc, StringBuilder docBuf, TrecDocParser.ParsePathType pathType) throws IOException, InterruptedException {
        Reader r = trecSrc.getTrecDocReader(docBuf);
        Date date = null;
        int h1 = docBuf.indexOf(DOCHDR);
        if (h1 >= 0) {
            int h2 = docBuf.indexOf(TERMINATING_DOCHDR, h1);
            String dateStr = TrecGov2Parser.extract(docBuf, DATE, DATE_END, h2, null);
            if (dateStr != null) {
                date = trecSrc.parseDate(dateStr);
            }
            r.mark(h2 + TERMINATING_DOCHDR_LENGTH);
        }
        r.reset();
        HTMLParser htmlParser = trecSrc.getHtmlParser();
        return htmlParser.parse(docData, name, date, null, r, null);
    }
}

