/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;
import java.util.Date;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.util.English;

public class LongToEnglishContentSource
extends ContentSource {
    private long counter = 0L;

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        long curCounter;
        docData.clear();
        LongToEnglishContentSource longToEnglishContentSource = this;
        synchronized (longToEnglishContentSource) {
            curCounter = this.counter;
            this.counter = this.counter == Long.MAX_VALUE ? Long.MIN_VALUE : ++this.counter;
        }
        docData.setBody(English.longToEnglish((long)curCounter));
        docData.setName("doc_" + String.valueOf(curCounter));
        docData.setTitle("title_" + String.valueOf(curCounter));
        docData.setDate(new Date());
        return docData;
    }

    public void resetInputs() throws IOException {
        this.counter = -9223372036854775798L;
    }
}

