/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.List;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.stats.Report;
import org.apache.lucene.benchmark.byTask.stats.TaskStats;
import org.apache.lucene.benchmark.byTask.tasks.RepSumByPrefTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepSelectByPrefTask
extends RepSumByPrefTask {
    public RepSelectByPrefTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public int doLogic() throws Exception {
        Report rp = this.reportSelectByPrefix(this.getRunData().getPoints().taskStats());
        System.out.println();
        System.out.println("------------> Report Select By Prefix (" + this.prefix + ") (" + rp.getSize() + " about " + rp.getReported() + " out of " + rp.getOutOf() + ")");
        System.out.println(rp.getText());
        System.out.println();
        return 0;
    }

    protected Report reportSelectByPrefix(List<TaskStats> taskStats) {
        String longestOp = this.longestOp(taskStats);
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        sb.append(this.tableTitle(longestOp));
        sb.append(newline);
        int reported = 0;
        for (TaskStats stat : taskStats) {
            if (stat.getElapsed() < 0L || !stat.getTask().getName().startsWith(this.prefix)) continue;
            ++reported;
            if (!first) {
                sb.append(newline);
            }
            first = false;
            String line = this.taskReportLine(longestOp, stat);
            if (taskStats.size() > 2 && reported % 2 == 0) {
                line = line.replaceAll("   ", " - ");
            }
            sb.append(line);
        }
        String reptxt = reported == 0 ? "No Matching Entries Were Found!" : sb.toString();
        return new Report(reptxt, reported, reported, taskStats.size());
    }
}

