/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.stats.Points;
import org.apache.lucene.benchmark.byTask.tasks.NewAnalyzerTask;
import org.apache.lucene.benchmark.byTask.tasks.ReadTask;
import org.apache.lucene.benchmark.byTask.tasks.SearchTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.FileUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class PerfRunData {
    private Points points;
    private Directory directory;
    private Analyzer analyzer;
    private DocMaker docMaker;
    private HashMap<Class<? extends ReadTask>, QueryMaker> readTaskQueryMaker;
    private Class<? extends QueryMaker> qmkrClass;
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private IndexWriter indexWriter;
    private Config config;
    private long startTimeMillis;

    public PerfRunData(Config config) throws Exception {
        this.config = config;
        this.analyzer = NewAnalyzerTask.createAnalyzer(config.get("analyzer", "org.apache.lucene.analysis.standard.StandardAnalyzer"));
        this.docMaker = Class.forName(config.get("doc.maker", "org.apache.lucene.benchmark.byTask.feeds.DocMaker")).asSubclass(DocMaker.class).newInstance();
        this.docMaker.setConfig(config);
        this.readTaskQueryMaker = new HashMap();
        this.qmkrClass = Class.forName(config.get("query.maker", "org.apache.lucene.benchmark.byTask.feeds.SimpleQueryMaker")).asSubclass(QueryMaker.class);
        this.reinit(false);
        this.points = new Points(config);
        if (Boolean.valueOf(config.get("log.queries", "false")).booleanValue()) {
            System.out.println("------------> queries:");
            System.out.println(this.getQueryMaker(new SearchTask(this)).printQueries());
        }
    }

    public void reinit(boolean eraseIndex) throws Exception {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (this.indexReader != null) {
            this.indexReader.close();
            this.indexReader = null;
        }
        if (this.directory != null) {
            this.directory.close();
        }
        if ("FSDirectory".equals(this.config.get("directory", "RAMDirectory"))) {
            File workDir = new File(this.config.get("work.dir", "work"));
            File indexDir = new File(workDir, "index");
            if (eraseIndex && indexDir.exists()) {
                FileUtils.fullyDelete(indexDir);
            }
            indexDir.mkdirs();
            this.directory = FSDirectory.open((File)indexDir);
        } else {
            this.directory = new RAMDirectory();
        }
        this.resetInputs();
        System.runFinalization();
        System.gc();
        this.setStartTimeMillis();
    }

    public long setStartTimeMillis() {
        this.startTimeMillis = System.currentTimeMillis();
        return this.startTimeMillis;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Points getPoints() {
        return this.points;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public synchronized IndexReader getIndexReader() {
        if (this.indexReader != null) {
            this.indexReader.incRef();
        }
        return this.indexReader;
    }

    public synchronized IndexSearcher getIndexSearcher() {
        if (this.indexReader != null) {
            this.indexReader.incRef();
        }
        return this.indexSearcher;
    }

    public synchronized void setIndexReader(IndexReader indexReader) throws IOException {
        if (this.indexReader != null) {
            this.indexReader.decRef();
        }
        this.indexReader = indexReader;
        if (indexReader != null) {
            indexReader.incRef();
            this.indexSearcher = new IndexSearcher(indexReader);
        } else {
            this.indexSearcher = null;
        }
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public void setIndexWriter(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public DocMaker getDocMaker() {
        return this.docMaker;
    }

    public Config getConfig() {
        return this.config;
    }

    public void resetInputs() throws IOException {
        this.docMaker.resetInputs();
        for (QueryMaker queryMaker : this.readTaskQueryMaker.values()) {
            queryMaker.resetInputs();
        }
    }

    public synchronized QueryMaker getQueryMaker(ReadTask readTask) {
        Class<?> readTaskClass = readTask.getClass();
        QueryMaker qm = this.readTaskQueryMaker.get(readTaskClass);
        if (qm == null) {
            try {
                qm = this.qmkrClass.newInstance();
                qm.setConfig(this.config);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.readTaskQueryMaker.put(readTaskClass, qm);
        }
        return qm;
    }
}

