/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.text.NumberFormat;
import java.util.ArrayList;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.tasks.ResetInputsTask;

public class TaskSequence
extends PerfTask {
    public static int REPEAT_EXHAUST = -2;
    private ArrayList tasks;
    private int repetitions = 1;
    private boolean parallel;
    private TaskSequence parent;
    private boolean letChildReport = true;
    private int rate = 0;
    private boolean perMin = false;
    private String seqName;
    private boolean exhausted = false;
    private boolean resetExhausted = false;
    private PerfTask[] tasksArray;
    private boolean anyExhaustibleTasks;
    private boolean collapsable = false;
    private boolean fixedTime;
    private double runTimeSec;

    public TaskSequence(PerfRunData runData, String name, TaskSequence parent, boolean parallel) {
        super(runData);
        boolean bl = this.collapsable = name == null;
        name = name != null ? name : (parallel ? "Par" : "Seq");
        this.setName(name);
        this.setSequenceName();
        this.parent = parent;
        this.parallel = parallel;
        this.tasks = new ArrayList();
    }

    public void close() throws Exception {
        this.initTasksArray();
        for (int i = 0; i < this.tasksArray.length; ++i) {
            this.tasksArray[i].close();
        }
        this.getRunData().getDocMaker().close();
    }

    private void initTasksArray() {
        if (this.tasksArray == null) {
            int numTasks = this.tasks.size();
            this.tasksArray = new PerfTask[numTasks];
            for (int k = 0; k < numTasks; ++k) {
                this.tasksArray[k] = (PerfTask)this.tasks.get(k);
                this.anyExhaustibleTasks |= this.tasksArray[k] instanceof ResetInputsTask;
                this.anyExhaustibleTasks |= this.tasksArray[k] instanceof TaskSequence;
            }
        }
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void setRunTime(double sec) throws Exception {
        this.runTimeSec = sec;
        this.fixedTime = true;
    }

    public void setRepetitions(int repetitions) throws Exception {
        this.fixedTime = false;
        this.repetitions = repetitions;
        if (repetitions == REPEAT_EXHAUST) {
            if (this.isParallel()) {
                throw new Exception("REPEAT_EXHAUST is not allowed for parallel tasks");
            }
            if (this.getRunData().getConfig().get("content.source.forever", true)) {
                throw new Exception("REPEAT_EXHAUST requires setting content.source.forever=false");
            }
        }
        this.setSequenceName();
    }

    public TaskSequence getParent() {
        return this.parent;
    }

    public int doLogic() throws Exception {
        this.resetExhausted = false;
        this.exhausted = false;
        return this.parallel ? this.doParallelTasks() : this.doSerialTasks();
    }

    private int doSerialTasks() throws Exception {
        if (this.rate > 0) {
            return this.doSerialTasksWithRate();
        }
        this.initTasksArray();
        int count = 0;
        long t0 = System.currentTimeMillis();
        long runTime = (long)(this.runTimeSec * 1000.0);
        for (int k = 0; this.fixedTime || this.repetitions == REPEAT_EXHAUST && !this.exhausted || k < this.repetitions; ++k) {
            for (int l = 0; l < this.tasksArray.length; ++l) {
                try {
                    PerfTask task = this.tasksArray[l];
                    count += task.runAndMaybeStats(this.letChildReport);
                    if (!this.anyExhaustibleTasks) continue;
                    this.updateExhausted(task);
                    continue;
                }
                catch (NoMoreDataException e) {
                    this.exhausted = true;
                }
            }
            if (!this.fixedTime || System.currentTimeMillis() - t0 <= runTime) continue;
            this.repetitions = k + 1;
            break;
        }
        return count;
    }

    private int doSerialTasksWithRate() throws Exception {
        this.initTasksArray();
        long delayStep = (this.perMin ? 60000 : 1000) / this.rate;
        long nextStartTime = System.currentTimeMillis();
        int count = 0;
        for (int k = 0; this.repetitions == REPEAT_EXHAUST && !this.exhausted || k < this.repetitions; ++k) {
            for (int l = 0; l < this.tasksArray.length; ++l) {
                PerfTask task = this.tasksArray[l];
                long waitMore = nextStartTime - System.currentTimeMillis();
                if (waitMore > 0L) {
                    Thread.sleep(waitMore);
                }
                nextStartTime += delayStep;
                try {
                    count += task.runAndMaybeStats(this.letChildReport);
                    if (!this.anyExhaustibleTasks) continue;
                    this.updateExhausted(task);
                    continue;
                }
                catch (NoMoreDataException e) {
                    this.exhausted = true;
                }
            }
        }
        return count;
    }

    private void updateExhausted(PerfTask task) {
        if (task instanceof ResetInputsTask) {
            this.exhausted = false;
            this.resetExhausted = true;
        } else if (task instanceof TaskSequence) {
            TaskSequence t = (TaskSequence)task;
            if (t.resetExhausted) {
                this.exhausted = false;
                this.resetExhausted = true;
                t.resetExhausted = false;
            } else {
                this.exhausted |= t.exhausted;
            }
        }
    }

    private int doParallelTasks() throws Exception {
        this.initTasksArray();
        final int[] count = new int[]{0};
        Thread[] t = new Thread[this.repetitions * this.tasks.size()];
        int indx = 0;
        for (int k = 0; k < this.repetitions; ++k) {
            for (int i = 0; i < this.tasksArray.length; ++i) {
                final PerfTask task = (PerfTask)this.tasksArray[i].clone();
                t[indx++] = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            int n = task.runAndMaybeStats(TaskSequence.this.letChildReport);
                            if (TaskSequence.this.anyExhaustibleTasks) {
                                TaskSequence.this.updateExhausted(task);
                            }
                            int[] nArray = count;
                            synchronized (count) {
                                count[0] = count[0] + n;
                                // ** MonitorExit[var2_4] (shouldn't be in output)
                            }
                        }
                        catch (NoMoreDataException e) {
                            TaskSequence.this.exhausted = true;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        {
                            return;
                        }
                    }
                };
            }
        }
        this.startThreads(t);
        for (int i = 0; i < t.length; ++i) {
            t[i].join();
        }
        return count[0];
    }

    private void startThreads(Thread[] t) throws InterruptedException {
        if (this.rate > 0) {
            this.startlThreadsWithRate(t);
            return;
        }
        for (int i = 0; i < t.length; ++i) {
            t[i].start();
        }
    }

    private void startlThreadsWithRate(Thread[] t) throws InterruptedException {
        long delayStep = (this.perMin ? 60000 : 1000) / this.rate;
        long nextStartTime = System.currentTimeMillis();
        for (int i = 0; i < t.length; ++i) {
            long waitMore = nextStartTime - System.currentTimeMillis();
            if (waitMore > 0L) {
                Thread.sleep(waitMore);
            }
            nextStartTime += delayStep;
            t[i].start();
        }
    }

    public void addTask(PerfTask task) {
        this.tasks.add(task);
        task.setDepth(this.getDepth() + 1);
    }

    public String toString() {
        String padd = this.getPadding();
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(this.parallel ? " [" : " {");
        sb.append(NEW_LINE);
        for (PerfTask task : this.tasks) {
            sb.append(task.toString());
            sb.append(NEW_LINE);
        }
        sb.append(padd);
        sb.append(!this.letChildReport ? ">" : (this.parallel ? "]" : "}"));
        if (this.fixedTime) {
            sb.append(" " + NumberFormat.getNumberInstance().format(this.runTimeSec) + "s");
        } else if (this.repetitions > 1) {
            sb.append(" * " + this.repetitions);
        } else if (this.repetitions == REPEAT_EXHAUST) {
            sb.append(" * EXHAUST");
        }
        if (this.rate > 0) {
            sb.append(",  rate: " + this.rate + "/" + (this.perMin ? "min" : "sec"));
        }
        return sb.toString();
    }

    public void setNoChildReport() {
        this.letChildReport = false;
        for (PerfTask task : this.tasks) {
            if (!(task instanceof TaskSequence)) continue;
            ((TaskSequence)task).setNoChildReport();
        }
    }

    public int getRate() {
        return this.perMin ? this.rate : 60 * this.rate;
    }

    public void setRate(int rate, boolean perMin) {
        this.rate = rate;
        this.perMin = perMin;
        this.setSequenceName();
    }

    private void setSequenceName() {
        this.seqName = super.getName();
        if (this.repetitions == REPEAT_EXHAUST) {
            this.seqName = this.seqName + "_Exhaust";
        } else if (this.repetitions > 1) {
            this.seqName = this.seqName + "_" + this.repetitions;
        }
        if (this.rate > 0) {
            this.seqName = this.seqName + "_" + this.rate + (this.perMin ? "/min" : "/sec");
        }
        if (this.parallel && this.seqName.toLowerCase().indexOf("par") < 0) {
            this.seqName = this.seqName + "_Par";
        }
    }

    public String getName() {
        return this.seqName;
    }

    public ArrayList getTasks() {
        return this.tasks;
    }

    protected Object clone() throws CloneNotSupportedException {
        TaskSequence res = (TaskSequence)super.clone();
        res.tasks = new ArrayList();
        for (int i = 0; i < this.tasks.size(); ++i) {
            res.tasks.add(((PerfTask)this.tasks.get(i)).clone());
        }
        return res;
    }

    public boolean isCollapsable() {
        return this.collapsable;
    }
}

