/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Stack;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class DirContentSource
extends ContentSource {
    private ThreadLocal dateFormat = new ThreadLocal();
    private File dataDir = null;
    private int iteration = 0;
    private Iterator inputFiles = null;

    private DateFormatInfo getDateFormatInfo() {
        DateFormatInfo dfi = (DateFormatInfo)this.dateFormat.get();
        if (dfi == null) {
            dfi = new DateFormatInfo();
            dfi.pos = new ParsePosition(0);
            dfi.df = new SimpleDateFormat("dd-MMM-yyyy kk:mm:ss.SSS", Locale.US);
            dfi.df.setLenient(true);
            this.dateFormat.set(dfi);
        }
        return dfi;
    }

    private Date parseDate(String dateStr) {
        DateFormatInfo dfi = this.getDateFormatInfo();
        dfi.pos.setIndex(0);
        dfi.pos.setErrorIndex(-1);
        return dfi.df.parse(dateStr.trim(), dfi.pos);
    }

    public void close() throws IOException {
        this.inputFiles = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        File f = null;
        String name = null;
        DirContentSource dirContentSource = this;
        synchronized (dirContentSource) {
            if (!this.inputFiles.hasNext()) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.inputFiles = new Iterator(this.dataDir);
                ++this.iteration;
            }
            f = (File)this.inputFiles.next();
            name = f.getCanonicalPath() + "_" + this.iteration;
        }
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = null;
        String dateStr = reader.readLine();
        reader.readLine();
        String title = reader.readLine();
        reader.readLine();
        StringBuffer bodyBuf = new StringBuffer(1024);
        while ((line = reader.readLine()) != null) {
            bodyBuf.append(line).append(' ');
        }
        reader.close();
        this.addBytes(f.length());
        Date date = this.parseDate(dateStr);
        docData.clear();
        docData.setName(name);
        docData.setBody(bodyBuf.toString());
        docData.setTitle(title);
        docData.setDate(date);
        return docData;
    }

    public synchronized void resetInputs() throws IOException {
        super.resetInputs();
        this.inputFiles = new Iterator(this.dataDir);
        this.iteration = 0;
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        File workDir = new File(config.get("work.dir", "work"));
        String d = config.get("docs.dir", "dir-out");
        this.dataDir = new File(d);
        if (!this.dataDir.isAbsolute()) {
            this.dataDir = new File(workDir, d);
        }
        this.inputFiles = new Iterator(this.dataDir);
        if (this.inputFiles == null) {
            throw new RuntimeException("No txt files in dataDir: " + this.dataDir.getAbsolutePath());
        }
    }

    public static class Iterator
    implements java.util.Iterator {
        int count = 0;
        Stack stack = new Stack();
        Comparator c = new Comparator();

        public Iterator(File f) {
            this.push(f);
        }

        void find() {
            if (this.stack.empty()) {
                return;
            }
            if (!((File)this.stack.peek()).isDirectory()) {
                return;
            }
            File f = (File)this.stack.pop();
            this.push(f);
        }

        void push(File f) {
            this.push(f.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            }));
            this.push(f.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith(".txt");
                }
            }));
            this.find();
        }

        void push(File[] files) {
            Arrays.sort(files, this.c);
            for (int i = 0; i < files.length; ++i) {
                this.stack.push(files[i]);
            }
        }

        public int getCount() {
            return this.count;
        }

        public boolean hasNext() {
            return this.stack.size() > 0;
        }

        public Object next() {
            assert (this.hasNext());
            ++this.count;
            Object object = this.stack.pop();
            this.find();
            return object;
        }

        public void remove() {
            throw new RuntimeException("cannot");
        }

        static class Comparator
        implements java.util.Comparator {
            Comparator() {
            }

            public int compare(Object _a, Object _b) {
                String b;
                String a;
                block3: {
                    int diff;
                    block2: {
                        a = _a.toString();
                        b = _b.toString();
                        diff = a.length() - b.length();
                        if (diff <= 0) break block2;
                        while (diff-- > 0) {
                            b = "0" + b;
                        }
                        break block3;
                    }
                    if (diff >= 0) break block3;
                    diff = -diff;
                    while (diff-- > 0) {
                        a = "0" + a;
                    }
                }
                return b.compareTo(a);
            }
        }
    }

    private static final class DateFormatInfo {
        DateFormat df;
        ParsePosition pos;

        private DateFormatInfo() {
        }
    }
}

