/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.utils;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.benchmark.quality.QualityQuery;
import org.apache.lucene.benchmark.quality.QualityQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

public class SimpleQQParser
implements QualityQueryParser {
    private String qqName;
    private String indexField;
    ThreadLocal queryParser = new ThreadLocal();

    public SimpleQQParser(String qqName, String indexField) {
        this.qqName = qqName;
        this.indexField = indexField;
    }

    public Query parse(QualityQuery qq) throws ParseException {
        QueryParser qp = (QueryParser)this.queryParser.get();
        if (qp == null) {
            qp = new QueryParser(this.indexField, (Analyzer)new StandardAnalyzer());
            this.queryParser.set(qp);
        }
        return qp.parse(qq.getValue(this.qqName));
    }
}

