/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.stats;

import java.util.Vector;
import org.apache.lucene.benchmark.Constants;
import org.apache.lucene.search.Query;

public class QueryData {
    public String id;
    public Query q;
    public boolean reopen;
    public boolean warmup;
    public boolean retrieve;

    public static QueryData[] getAll(Query[] queries) {
        Vector<QueryData> vqd = new Vector<QueryData>();
        for (int i = 0; i < queries.length; ++i) {
            for (int r = 1; r >= 0; --r) {
                for (int w = 1; w >= 0; --w) {
                    for (int t = 0; t < 2; ++t) {
                        QueryData qd = new QueryData();
                        qd.id = "qd-" + i + r + w + t;
                        qd.reopen = Constants.BOOLEANS[r];
                        qd.warmup = Constants.BOOLEANS[w];
                        qd.retrieve = Constants.BOOLEANS[t];
                        qd.q = queries[i];
                        vqd.add(qd);
                    }
                }
            }
        }
        return vqd.toArray(new QueryData[0]);
    }

    public static String getLabels() {
        return "# Query data: R-reopen, W-warmup, T-retrieve, N-no";
    }

    public String toString() {
        return this.id + " " + (this.reopen ? "R" : "NR") + " " + (this.warmup ? "W" : "NW") + " " + (this.retrieve ? "T" : "NT") + " [" + this.q.toString() + "]";
    }
}

