/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;

public class NearRealtimeReaderTask
extends PerfTask {
    ReopenThread t;
    float pauseSec = 3.0f;

    public NearRealtimeReaderTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws IOException {
        if (this.t == null) {
            IndexWriter w = this.getRunData().getIndexWriter();
            this.t = new ReopenThread(w, this.pauseSec);
            this.t.start();
        }
        return 1;
    }

    public void setParams(String params) {
        super.setParams(params);
        this.pauseSec = Float.parseFloat(params);
    }

    public boolean supportsParams() {
        return true;
    }

    public void close() throws InterruptedException {
        if (this.t != null) {
            this.t.done = true;
            this.t.join();
        }
    }

    private static class ReopenThread
    extends Thread {
        final IndexWriter writer;
        final int pauseMsec;
        public volatile boolean done;

        ReopenThread(IndexWriter writer, float pauseSec) {
            this.writer = writer;
            this.pauseMsec = (int)(1000.0f * pauseSec);
            this.setDaemon(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            IndexReader reader = null;
            TermQuery query = new TermQuery(new Term("body", "1"));
            SortField sf = new SortField("docdate", 6);
            Sort sort = new Sort(sf);
            block4: while (true) {
                try {
                    while (!this.done) {
                        long t0 = System.currentTimeMillis();
                        if (reader == null) {
                            reader = this.writer.getReader();
                        } else {
                            IndexReader newReader = reader.reopen();
                            if (reader != newReader) {
                                reader.close();
                                reader = newReader;
                            }
                        }
                        long t1 = System.currentTimeMillis();
                        TopFieldDocs hits = new IndexSearcher(reader).search((Query)query, null, 10, sort);
                        long t2 = System.currentTimeMillis();
                        System.out.println("nrt: open " + (t1 - t0) + " msec; search " + (t2 - t1) + " msec, " + hits.totalHits + " results; " + reader.numDocs() + " docs");
                        long t4 = System.currentTimeMillis();
                        int delay = (int)((long)this.pauseMsec - (t4 - t0));
                        if (delay <= 0) continue;
                        try {
                            Thread.sleep(delay);
                            continue block4;
                        }
                        catch (InterruptedException ie) {
                            throw new RuntimeException(ie);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

