/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.ReadTask;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class SearchWithSortTask
extends ReadTask {
    private Sort sort;

    public SearchWithSortTask(PerfRunData runData) {
        super(runData);
    }

    public void setParams(String sortField) {
        super.setParams(sortField);
        String[] fields = sortField.split(",");
        SortField[] sortFields = new SortField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String typeString;
            String fieldName;
            String field = fields[i];
            int index = field.lastIndexOf(":");
            if (index != -1) {
                fieldName = field.substring(0, index);
                typeString = field.substring(index, field.length());
            } else {
                typeString = "auto";
                fieldName = field;
            }
            int type = this.getType(typeString);
            sortFields[i] = new SortField(fieldName, type);
        }
        this.sort = new Sort(sortFields);
    }

    private int getType(String typeString) {
        int type = typeString.equals("float") ? 5 : (typeString.equals("int") ? 4 : (typeString.equals("string") ? 3 : 2));
        return type;
    }

    public boolean supportsParams() {
        return true;
    }

    public QueryMaker getQueryMaker() {
        return this.getRunData().getQueryMaker(this);
    }

    public boolean withRetrieve() {
        return false;
    }

    public boolean withSearch() {
        return true;
    }

    public boolean withTraverse() {
        return false;
    }

    public boolean withWarm() {
        return false;
    }

    public Sort getSort() {
        if (this.sort == null) {
            throw new IllegalStateException("No sort field was set");
        }
        return this.sort;
    }
}

