/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.SearchTravTask;
import org.apache.lucene.document.Document;

public class SearchTravRetHighlightTask
extends SearchTravTask {
    protected int numToHighlight = Integer.MAX_VALUE;
    protected boolean mergeContiguous;
    protected int maxFrags = 2;
    protected Set paramFields = Collections.EMPTY_SET;

    public SearchTravRetHighlightTask(PerfRunData runData) {
        super(runData);
    }

    public void setup() throws Exception {
        super.setup();
        PerfRunData data = this.getRunData();
        if (!data.getConfig().get("doc.stored", false)) {
            throw new Exception("doc.stored must be set to true");
        }
    }

    public boolean withRetrieve() {
        return true;
    }

    public int numToHighlight() {
        return this.numToHighlight;
    }

    public boolean isMergeContiguousFragments() {
        return this.mergeContiguous;
    }

    public int maxNumFragments() {
        return this.maxFrags;
    }

    protected Collection getFieldsToHighlight(Document document) {
        Collection result = super.getFieldsToHighlight(document);
        if (!this.paramFields.isEmpty() && !result.isEmpty()) {
            result.retainAll(this.paramFields);
        } else {
            result = this.paramFields;
        }
        return result;
    }

    public void setParams(String params) {
        String[] splits = params.split(",");
        for (int i = 0; i < splits.length; ++i) {
            if (splits[i].startsWith("size[")) {
                this.traversalSize = (int)Float.parseFloat(splits[i].substring("size[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("highlight[")) {
                this.numToHighlight = (int)Float.parseFloat(splits[i].substring("highlight[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("maxFrags[")) {
                this.maxFrags = (int)Float.parseFloat(splits[i].substring("maxFrags[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("mergeContiguous[")) {
                this.mergeContiguous = Boolean.valueOf(splits[i].substring("mergeContiguous[".length(), splits[i].length() - 1));
                continue;
            }
            if (!splits[i].startsWith("fields[")) continue;
            this.paramFields = new HashSet();
            String fieldNames = splits[i].substring("fields[".length(), splits[i].length() - 1);
            String[] fieldSplits = fieldNames.split(";");
            for (int j = 0; j < fieldSplits.length; ++j) {
                this.paramFields.add(fieldSplits[j]);
            }
        }
    }
}

