/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.stats.Report;
import org.apache.lucene.benchmark.byTask.stats.TaskStats;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Format;

public abstract class ReportTask
extends PerfTask {
    protected static final String newline = System.getProperty("line.separator");
    protected static final String OP = "Operation  ";
    protected static final String ROUND = " round";
    protected static final String RUNCNT = "   runCnt";
    protected static final String RECCNT = "   recsPerRun";
    protected static final String RECSEC = "        rec/s";
    protected static final String ELAPSED = "  elapsedSec";
    protected static final String USEDMEM = "    avgUsedMem";
    protected static final String TOTMEM = "    avgTotalMem";
    protected static final String[] COLS = new String[]{"   runCnt", "   recsPerRun", "        rec/s", "  elapsedSec", "    avgUsedMem", "    avgTotalMem"};

    public ReportTask(PerfRunData runData) {
        super(runData);
    }

    protected boolean shouldNeverLogAtStart() {
        return true;
    }

    protected boolean shouldNotRecordStats() {
        return true;
    }

    protected String tableTitle(String longestOp) {
        StringBuffer sb = new StringBuffer();
        sb.append(Format.format(OP, longestOp));
        sb.append(ROUND);
        sb.append(this.getRunData().getConfig().getColsNamesForValsByRound());
        for (int i = 0; i < COLS.length; ++i) {
            sb.append(COLS[i]);
        }
        return sb.toString();
    }

    protected String longestOp(Iterator taskStats) {
        String longest = OP;
        while (taskStats.hasNext()) {
            String name;
            TaskStats stat = (TaskStats)taskStats.next();
            if (stat.getElapsed() < 0L || (name = stat.getTask().getName()).length() <= longest.length()) continue;
            longest = name;
        }
        return longest;
    }

    protected String taskReportLine(String longestOp, TaskStats stat) {
        PerfTask task = stat.getTask();
        StringBuffer sb = new StringBuffer();
        sb.append(Format.format(task.getName(), longestOp));
        String round = stat.getRound() >= 0 ? "" + stat.getRound() : "-";
        sb.append(Format.formatPaddLeft(round, ROUND));
        sb.append(this.getRunData().getConfig().getColsValuesForValsByRound(stat.getRound()));
        sb.append(Format.format(stat.getNumRuns(), RUNCNT));
        sb.append(Format.format(stat.getCount() / stat.getNumRuns(), RECCNT));
        long elapsed = stat.getElapsed() > 0L ? stat.getElapsed() : 1L;
        sb.append(Format.format(1, (float)((double)stat.getCount() * 1000.0 / (double)elapsed), RECSEC));
        sb.append(Format.format(2, (float)stat.getElapsed() / 1000.0f, ELAPSED));
        sb.append(Format.format(0, (float)stat.getMaxUsedMem() / (float)stat.getNumRuns(), USEDMEM));
        sb.append(Format.format(0, (float)stat.getMaxTotMem() / (float)stat.getNumRuns(), TOTMEM));
        return sb.toString();
    }

    protected Report genPartialReport(int reported, LinkedHashMap partOfTasks, int totalSize) {
        String longetOp = this.longestOp(partOfTasks.values().iterator());
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        sb.append(this.tableTitle(longetOp));
        sb.append(newline);
        int lineNum = 0;
        Iterator it = partOfTasks.values().iterator();
        while (it.hasNext()) {
            TaskStats stat = (TaskStats)it.next();
            if (!first) {
                sb.append(newline);
            }
            first = false;
            String line = this.taskReportLine(longetOp, stat);
            if (partOfTasks.size() > 2 && ++lineNum % 2 == 0) {
                line = line.replaceAll("   ", " - ");
            }
            sb.append(line);
        }
        String reptxt = reported == 0 ? "No Matching Entries Were Found!" : sb.toString();
        return new Report(reptxt, partOfTasks.size(), reported, totalSize);
    }
}

