/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.CreateIndexTask;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexWriter;

public class OpenIndexTask
extends PerfTask {
    public static final int DEFAULT_MAX_BUFFERED = -1;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_MERGE_PFACTOR = 10;
    public static final double DEFAULT_RAM_FLUSH_MB = 16.0;
    public static final boolean DEFAULT_AUTO_COMMIT = true;

    public OpenIndexTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws IOException {
        PerfRunData runData = this.getRunData();
        Config config = runData.getConfig();
        IndexWriter writer = new IndexWriter(runData.getDirectory(), config.get("autocommit", true), runData.getAnalyzer(), false);
        CreateIndexTask.setIndexWriterConfig(writer, config);
        runData.setIndexWriter(writer);
        return 1;
    }
}

