/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;

public class CreateIndexTask
extends PerfTask {
    public CreateIndexTask(PerfRunData runData) {
        super(runData);
    }

    public static void setIndexWriterConfig(IndexWriter writer, Config config) throws IOException {
        String mergeScheduler = config.get("merge.scheduler", "org.apache.lucene.index.ConcurrentMergeScheduler");
        RuntimeException err = null;
        try {
            writer.setMergeScheduler((MergeScheduler)Class.forName(mergeScheduler).newInstance());
        }
        catch (IllegalAccessException iae) {
            err = new RuntimeException("unable to instantiate class '" + mergeScheduler + "' as merge scheduler");
            err.initCause(iae);
        }
        catch (InstantiationException ie) {
            err = new RuntimeException("unable to instantiate class '" + mergeScheduler + "' as merge scheduler");
            err.initCause(ie);
        }
        catch (ClassNotFoundException cnfe) {
            err = new RuntimeException("unable to load class '" + mergeScheduler + "' as merge scheduler");
            err.initCause(cnfe);
        }
        if (err != null) {
            throw err;
        }
        String mergePolicy = config.get("merge.policy", "org.apache.lucene.index.LogByteSizeMergePolicy");
        err = null;
        try {
            writer.setMergePolicy((MergePolicy)Class.forName(mergePolicy).newInstance());
        }
        catch (IllegalAccessException iae) {
            err = new RuntimeException("unable to instantiate class '" + mergePolicy + "' as merge policy");
            err.initCause(iae);
        }
        catch (InstantiationException ie) {
            err = new RuntimeException("unable to instantiate class '" + mergePolicy + "' as merge policy");
            err.initCause(ie);
        }
        catch (ClassNotFoundException cnfe) {
            err = new RuntimeException("unable to load class '" + mergePolicy + "' as merge policy");
            err.initCause(cnfe);
        }
        if (err != null) {
            throw err;
        }
        writer.setUseCompoundFile(config.get("compound", true));
        writer.setMergeFactor(config.get("merge.factor", 10));
        writer.setMaxFieldLength(config.get("max.field.length", 10000));
        double ramBuffer = config.get("ram.flush.mb", 16.0);
        int maxBuffered = config.get("max.buffered", -1);
        if (maxBuffered == -1) {
            writer.setRAMBufferSizeMB(ramBuffer);
            writer.setMaxBufferedDocs(maxBuffered);
        } else {
            writer.setMaxBufferedDocs(maxBuffered);
            writer.setRAMBufferSizeMB(ramBuffer);
        }
    }

    public int doLogic() throws IOException {
        PerfRunData runData = this.getRunData();
        Config config = runData.getConfig();
        IndexWriter writer = new IndexWriter(runData.getDirectory(), runData.getConfig().get("autocommit", true), runData.getAnalyzer(), true);
        CreateIndexTask.setIndexWriterConfig(writer, config);
        runData.setIndexWriter(writer);
        return 1;
    }
}

