/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.lucene.benchmark.byTask.feeds.BasicDocMaker;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class LineDocMaker
extends BasicDocMaker {
    FileInputStream fileIS;
    BufferedReader fileIn;
    ThreadLocal docState = new ThreadLocal();
    private String fileName;
    private static int READER_BUFFER_BYTES = 65536;
    private final DocState localDocState = new DocState();
    private boolean doReuseFields = true;

    protected DocData getNextDocData() throws Exception {
        throw new RuntimeException("not implemented");
    }

    private DocState getDocState() {
        DocState ds = (DocState)this.docState.get();
        if (ds == null) {
            ds = new DocState();
            this.docState.set(ds);
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document makeDocument() throws Exception {
        String line;
        LineDocMaker lineDocMaker = this;
        synchronized (lineDocMaker) {
            while ((line = this.fileIn.readLine()) == null) {
                this.openFile();
                if (this.forever) continue;
                throw new NoMoreDataException();
            }
        }
        if (this.doReuseFields) {
            return this.getDocState().setFields(line);
        }
        return this.localDocState.setFields(line);
    }

    public Document makeDocument(int size) throws Exception {
        throw new RuntimeException("cannot change document size with LineDocMaker; please use DirDocMaker instead");
    }

    public synchronized void resetInputs() {
        super.resetInputs();
        this.fileName = this.config.get("docs.file", null);
        if (this.fileName == null) {
            throw new RuntimeException("docs.file must be set");
        }
        this.openFile();
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        this.doReuseFields = config.get("doc.reuse.fields", true);
    }

    synchronized void openFile() {
        try {
            if (this.fileIn != null) {
                this.fileIn.close();
            }
            this.fileIS = new FileInputStream(this.fileName);
            this.fileIn = new BufferedReader(new InputStreamReader((InputStream)this.fileIS, "UTF-8"), READER_BUFFER_BYTES);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int numUniqueTexts() {
        return -1;
    }

    class DocState {
        Document doc;
        Field bodyField;
        Field titleField;
        Field dateField;
        Field idField;
        static final String SEP = "\t";

        public DocState() {
            this.bodyField = new Field("body", "", LineDocMaker.this.storeVal, Field.Index.ANALYZED, LineDocMaker.this.termVecVal);
            this.titleField = new Field("doctitle", "", LineDocMaker.this.storeVal, Field.Index.ANALYZED, LineDocMaker.this.termVecVal);
            this.dateField = new Field("docdate", "", LineDocMaker.this.storeVal, Field.Index.ANALYZED, LineDocMaker.this.termVecVal);
            this.idField = new Field("docid", "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
            this.doc = new Document();
            this.doc.add((Fieldable)this.bodyField);
            this.doc.add((Fieldable)this.titleField);
            this.doc.add((Fieldable)this.dateField);
            this.doc.add((Fieldable)this.idField);
        }

        public Document setFields(String line) {
            String body;
            String date;
            String title;
            int spot = line.indexOf(SEP);
            if (spot != -1) {
                title = line.substring(0, spot);
                int spot2 = line.indexOf(SEP, 1 + spot);
                if (spot2 != -1) {
                    date = line.substring(1 + spot, spot2);
                    body = line.substring(1 + spot2, line.length());
                } else {
                    body = "";
                    date = "";
                }
            } else {
                body = "";
                date = "";
                title = "";
            }
            if (LineDocMaker.this.doReuseFields) {
                this.titleField.setValue(title);
                this.dateField.setValue(date);
                this.bodyField.setValue(body);
                return this.doc;
            }
            Field localTitleField = new Field("doctitle", title, LineDocMaker.this.storeVal, Field.Index.ANALYZED, LineDocMaker.this.termVecVal);
            Field localBodyField = new Field("body", body, LineDocMaker.this.storeVal, Field.Index.ANALYZED, LineDocMaker.this.termVecVal);
            Field localDateField = new Field("body", date, LineDocMaker.this.storeVal, Field.Index.ANALYZED, LineDocMaker.this.termVecVal);
            Document localDoc = new Document();
            localDoc.add((Fieldable)localBodyField);
            localDoc.add((Fieldable)localTitleField);
            localDoc.add((Fieldable)localDateField);
            return localDoc;
        }
    }
}

