/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.stats;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.Constants;
import org.apache.lucene.benchmark.stats.MemUsage;
import org.apache.lucene.benchmark.stats.QueryData;
import org.apache.lucene.benchmark.stats.TestRunData;
import org.apache.lucene.benchmark.stats.TimeData;
import org.apache.lucene.store.Directory;

public class TestData {
    public static int[] MAX_BUFFERED_DOCS_COUNTS = new int[]{10, 20, 50, 100, 200, 500};
    public static int[] MERGEFACTOR_COUNTS = new int[]{10, 20, 50, 100, 200, 500};
    private String id;
    private long heap;
    private Vector runData = new Vector();
    private int maxBufferedDocs;
    private int mergeFactor;
    private File source;
    private Directory directory;
    private Analyzer analyzer;
    private boolean compound;
    private boolean optimize;
    private QueryData[] queries;
    static final String ID = "# testData id     ";
    static final String OP = "operation      ";
    static final String RUNCNT = "     runCnt";
    static final String RECCNT = "     recCnt";
    static final String RECSEC = "          rec/s";
    static final String FREEMEM = "       avgFreeMem";
    static final String TOTMEM = "      avgTotalMem";
    static final String[] COLS = new String[]{"# testData id     ", "operation      ", "     runCnt", "     recCnt", "          rec/s", "       avgFreeMem", "      avgTotalMem"};
    private static NumberFormat[] numFormat = new NumberFormat[]{NumberFormat.getInstance(), NumberFormat.getInstance()};
    private static final String padd = "                                  ";

    public TestData() {
        this.heap = Runtime.getRuntime().maxMemory();
    }

    public String showRunData(String prefix) {
        String label;
        if (this.runData.size() == 0) {
            return "# [NO RUN DATA]";
        }
        HashMap<String, LDCounter> resByTask = new HashMap<String, LDCounter>();
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        sb.append("warm = Warm Index Reader").append(lineSep).append("srch = Search Index").append(lineSep).append("trav = Traverse Hits list, optionally retrieving document").append(lineSep).append(lineSep);
        for (int i = 0; i < COLS.length; ++i) {
            sb.append(COLS[i]);
        }
        sb.append("\n");
        LinkedHashMap<String, LCounter[]> mapMem = new LinkedHashMap<String, LCounter[]>();
        LinkedHashMap<String, DCounter> mapSpeed = new LinkedHashMap<String, DCounter>();
        for (int i = 0; i < this.runData.size(); ++i) {
            TestRunData trd = (TestRunData)this.runData.get(i);
            Collection labels = trd.getLabels();
            Iterator it = labels.iterator();
            while (it.hasNext()) {
                TimeData td;
                String label2 = (String)it.next();
                MemUsage mem = trd.getMemUsage(label2);
                if (mem != null) {
                    LCounter[] tm = (LCounter[])mapMem.get(label2);
                    if (tm == null) {
                        tm = new LCounter[]{new LCounter(), new LCounter()};
                        mapMem.put(label2, tm);
                    }
                    tm[0].total += mem.avgFree;
                    ++tm[0].count;
                    tm[1].total += mem.avgTotal;
                    ++tm[1].count;
                }
                if ((td = trd.getTotals(label2)) == null) continue;
                DCounter dc = (DCounter)mapSpeed.get(label2);
                if (dc == null) {
                    dc = new DCounter();
                    mapSpeed.put(label2, dc);
                }
                ++dc.count;
                dc.total = dc.total + (double)(td.count > 0L && td.elapsed <= 0L ? 1L : td.elapsed);
                dc.recordCount = (int)((long)dc.recordCount + td.count);
            }
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        Iterator it = mapSpeed.keySet().iterator();
        while (it.hasNext()) {
            label = (String)it.next();
            DCounter dc = (DCounter)mapSpeed.get(label);
            res.put(label, TestData.format(dc.count, RUNCNT) + TestData.format(dc.recordCount / dc.count, RECCNT) + TestData.format(1, (float)((double)dc.recordCount * 1000.0 / (dc.total > 0.0 ? dc.total : 1.0)), RECSEC));
            String task = label.substring(label.lastIndexOf("-") + 1);
            LDCounter ldc = (LDCounter)resByTask.get(task);
            if (ldc == null) {
                ldc = new LDCounter();
                resByTask.put(task, ldc);
            }
            ldc.Dcount += dc.count;
            ldc.DrecordCount += dc.recordCount;
            ldc.Dtotal = ldc.Dtotal + (dc.count > 0 && dc.total <= 0.0 ? 1.0 : dc.total);
        }
        it = mapMem.keySet().iterator();
        while (it.hasNext()) {
            label = (String)it.next();
            LCounter[] lc = (LCounter[])mapMem.get(label);
            String speed = (String)res.get(label);
            boolean makeSpeed = false;
            if (speed == null) {
                makeSpeed = true;
                speed = TestData.format(lc[0].count, RUNCNT) + TestData.format(0, RECCNT) + TestData.format(0, 0.0f, RECSEC);
            }
            res.put(label, speed + TestData.format(0, lc[0].total / (long)lc[0].count, FREEMEM) + TestData.format(0, lc[1].total / (long)lc[1].count, TOTMEM));
            String task = label.substring(label.lastIndexOf("-") + 1);
            LDCounter ldc = (LDCounter)resByTask.get(task);
            if (ldc == null) {
                ldc = new LDCounter();
                resByTask.put(task, ldc);
                makeSpeed = true;
            }
            if (makeSpeed) {
                ldc.Dcount += lc[0].count;
            }
            ldc.Lcount0 += lc[0].count;
            ldc.Lcount1 += lc[1].count;
            ldc.Ltotal0 += lc[0].total;
            ldc.Ltotal1 += lc[1].total;
        }
        it = res.keySet().iterator();
        while (it.hasNext()) {
            label = (String)it.next();
            sb.append(TestData.format(prefix, ID));
            sb.append(TestData.format(label, OP));
            sb.append(res.get(label)).append("\n");
        }
        sb.append("\n");
        for (int i = 0; i < COLS.length; ++i) {
            sb.append(COLS[i]);
        }
        sb.append("\n");
        it = resByTask.keySet().iterator();
        while (it.hasNext()) {
            String task = (String)it.next();
            LDCounter ldc = (LDCounter)resByTask.get(task);
            sb.append(TestData.format("    ", ID));
            sb.append(TestData.format(task, OP));
            sb.append(TestData.format(ldc.Dcount, RUNCNT));
            sb.append(TestData.format(ldc.DrecordCount / ldc.Dcount, RECCNT));
            sb.append(TestData.format(1, (float)((double)ldc.DrecordCount * 1000.0 / (ldc.Dtotal > 0.0 ? ldc.Dtotal : 1.0)), RECSEC));
            sb.append(TestData.format(0, ldc.Ltotal0 / (long)ldc.Lcount0, FREEMEM));
            sb.append(TestData.format(0, ldc.Ltotal1 / (long)ldc.Lcount1, TOTMEM));
            sb.append("\n");
        }
        return sb.toString();
    }

    static String format(int numFracDigits, float f, String col) {
        String res = padd + numFormat[numFracDigits].format(f);
        return res.substring(res.length() - col.length());
    }

    static String format(int n, String col) {
        String res = padd + n;
        return res.substring(res.length() - col.length());
    }

    static String format(String s, String col) {
        return (s + padd).substring(0, col.length());
    }

    public static TestData[] getAll(File[] sources, Analyzer[] analyzers) {
        ArrayList<Object> res = new ArrayList<Object>(50);
        TestData ref = new TestData();
        for (int q = 0; q < analyzers.length; ++q) {
            for (int m = 0; m < sources.length; ++m) {
                for (int i = 0; i < MAX_BUFFERED_DOCS_COUNTS.length; ++i) {
                    for (int k = 0; k < MERGEFACTOR_COUNTS.length; ++k) {
                        for (int n = 0; n < Constants.BOOLEANS.length; ++n) {
                            for (int p = 0; p < Constants.BOOLEANS.length; ++p) {
                                ref.id = "td-" + q + m + i + k + n + p;
                                ref.source = sources[m];
                                ref.analyzer = analyzers[q];
                                ref.maxBufferedDocs = MAX_BUFFERED_DOCS_COUNTS[i];
                                ref.mergeFactor = MERGEFACTOR_COUNTS[k];
                                ref.compound = Constants.BOOLEANS[n];
                                ref.optimize = Constants.BOOLEANS[p];
                                try {
                                    res.add(ref.clone());
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
        }
        return res.toArray(new TestData[0]);
    }

    public static TestData[] getTestDataMinMaxMergeAndMaxBuffered(File[] sources, Analyzer[] analyzers) {
        ArrayList<Object> res = new ArrayList<Object>(50);
        TestData ref = new TestData();
        for (int q = 0; q < analyzers.length; ++q) {
            for (int m = 0; m < sources.length; ++m) {
                ref.id = "td-" + q + m + "_" + 10 + "_" + 10;
                ref.source = sources[m];
                ref.analyzer = analyzers[q];
                ref.maxBufferedDocs = 10;
                ref.mergeFactor = 10;
                ref.compound = true;
                ref.optimize = true;
                try {
                    res.add(ref.clone());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ref.id = "td-" + q + m + "_" + 10 + "_" + 100;
                ref.source = sources[m];
                ref.analyzer = analyzers[q];
                ref.maxBufferedDocs = 10;
                ref.mergeFactor = 100;
                ref.compound = true;
                ref.optimize = true;
                try {
                    res.add(ref.clone());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ref.id = "td-" + q + m + "_" + 100 + "_" + 10;
                ref.source = sources[m];
                ref.analyzer = analyzers[q];
                ref.maxBufferedDocs = 100;
                ref.mergeFactor = 10;
                ref.compound = true;
                ref.optimize = true;
                try {
                    res.add(ref.clone());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ref.id = "td-" + q + m + "_" + 100 + "_" + 100;
                ref.source = sources[m];
                ref.analyzer = analyzers[q];
                ref.maxBufferedDocs = 100;
                ref.mergeFactor = 100;
                ref.compound = true;
                ref.optimize = true;
                try {
                    res.add(ref.clone());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return res.toArray(new TestData[0]);
    }

    protected Object clone() {
        TestData cl = new TestData();
        cl.id = this.id;
        cl.compound = this.compound;
        cl.heap = this.heap;
        cl.mergeFactor = this.mergeFactor;
        cl.maxBufferedDocs = this.maxBufferedDocs;
        cl.optimize = this.optimize;
        cl.source = this.source;
        cl.directory = this.directory;
        cl.analyzer = this.analyzer;
        return cl;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("#-- ID: ").append(this.id).append(", ").append(new Date()).append(", heap=").append(this.heap).append(" --\n");
        res.append("# source=").append(this.source).append(", directory=").append(this.directory).append("\n");
        res.append("# maxBufferedDocs=").append(this.maxBufferedDocs).append(", mergeFactor=").append(this.mergeFactor);
        res.append(", compound=").append(this.compound).append(", optimize=").append(this.optimize).append("\n");
        if (this.queries != null) {
            res.append(QueryData.getLabels()).append("\n");
            for (int i = 0; i < this.queries.length; ++i) {
                res.append("# ").append(this.queries[i].toString()).append("\n");
            }
        }
        return res.toString();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean isCompound() {
        return this.compound;
    }

    public void setCompound(boolean compound) {
        this.compound = compound;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public long getHeap() {
        return this.heap;
    }

    public void setHeap(long heap) {
        this.heap = heap;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        this.maxBufferedDocs = maxBufferedDocs;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public QueryData[] getQueries() {
        return this.queries;
    }

    public void setQueries(QueryData[] queries) {
        this.queries = queries;
    }

    public Vector getRunData() {
        return this.runData;
    }

    public void setRunData(Vector runData) {
        this.runData = runData;
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    static {
        numFormat[0].setMaximumFractionDigits(0);
        numFormat[0].setMinimumFractionDigits(0);
        numFormat[1].setMaximumFractionDigits(1);
        numFormat[1].setMinimumFractionDigits(1);
    }

    private static class LDCounter {
        double Dtotal;
        int Dcount;
        int DrecordCount;
        long Ltotal0;
        int Lcount0;
        long Ltotal1;
        int Lcount1;

        private LDCounter() {
        }
    }

    private static class LCounter {
        long total;
        int count;

        private LCounter() {
        }
    }

    private static class DCounter {
        double total;
        int count;
        int recordCount;

        private DCounter() {
        }
    }
}

