/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.SearchTravTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;

public class SearchTravRetLoadFieldSelectorTask
extends SearchTravTask {
    protected FieldSelector fieldSelector;

    public SearchTravRetLoadFieldSelectorTask(PerfRunData runData) {
        super(runData);
    }

    public boolean withRetrieve() {
        return true;
    }

    protected Document retrieveDoc(IndexReader ir, int id) throws IOException {
        return ir.document(id, this.fieldSelector);
    }

    public void setParams(String params) {
        this.params = params;
        HashSet<String> fieldsToLoad = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(params, ",");
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            fieldsToLoad.add(s);
        }
        this.fieldSelector = new SetBasedFieldSelector(fieldsToLoad, Collections.EMPTY_SET);
    }

    public boolean supportsParams() {
        return true;
    }
}

