/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Stack;
import org.apache.lucene.benchmark.byTask.feeds.BasicDocMaker;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class DirDocMaker
extends BasicDocMaker {
    protected ThreadLocal dateFormat = new ThreadLocal();
    protected File dataDir = null;
    protected int iteration = 0;
    protected Iterator inputFiles = null;
    static /* synthetic */ Class class$org$apache$lucene$benchmark$byTask$feeds$DirDocMaker;

    public void setConfig(Config config) {
        super.setConfig(config);
        String d = config.get("docs.dir", "dir-out");
        this.dataDir = new File(d);
        if (!this.dataDir.isAbsolute()) {
            this.dataDir = new File(new File("work"), d);
        }
        this.inputFiles = new Iterator(this.dataDir);
        if (this.inputFiles == null) {
            throw new RuntimeException("No txt files in dataDir: " + this.dataDir.getAbsolutePath());
        }
    }

    protected DateFormat getDateFormat() {
        DateFormat df = (DateFormat)this.dateFormat.get();
        if (df == null) {
            df = new SimpleDateFormat("dd-MMM-yyyy kk:mm:ss.SSS", Locale.US);
            df.setLenient(true);
            this.dateFormat.set(df);
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocData getNextDocData() throws Exception {
        File f = null;
        String name = null;
        DirDocMaker dirDocMaker = this;
        synchronized (dirDocMaker) {
            if (!this.inputFiles.hasNext()) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.inputFiles = new Iterator(this.dataDir);
                ++this.iteration;
            }
            f = (File)this.inputFiles.next();
            name = f.getCanonicalPath() + "_" + this.iteration;
        }
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = null;
        String dateStr = reader.readLine();
        reader.readLine();
        String title = reader.readLine();
        reader.readLine();
        StringBuffer bodyBuf = new StringBuffer(1024);
        while ((line = reader.readLine()) != null) {
            bodyBuf.append(line).append(' ');
        }
        reader.close();
        this.addBytes(f.length());
        Date date = this.getDateFormat().parse(dateStr.trim());
        return new DocData(name, bodyBuf.toString(), title, null, date);
    }

    public synchronized void resetInputs() {
        super.resetInputs();
        this.inputFiles = new Iterator(this.dataDir);
        this.iteration = 0;
    }

    public int numUniqueTexts() {
        return this.inputFiles.getCount();
    }

    public static class Iterator
    implements java.util.Iterator {
        int count = 0;
        Stack stack = new Stack();
        Comparator c = new Comparator();
        static final /* synthetic */ boolean $assertionsDisabled;

        public int getCount() {
            return this.count;
        }

        void push(File[] files) {
            Arrays.sort(files, this.c);
            for (int i = 0; i < files.length; ++i) {
                this.stack.push(files[i]);
            }
        }

        void push(File f) {
            this.push(f.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory();
                }
            }));
            this.push(f.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().endsWith(".txt");
                }
            }));
            this.find();
        }

        void find() {
            if (this.stack.empty()) {
                return;
            }
            if (!((File)this.stack.peek()).isDirectory()) {
                return;
            }
            File f = (File)this.stack.pop();
            this.push(f);
        }

        public Iterator(File f) {
            this.push(f);
        }

        public void remove() {
            throw new RuntimeException("cannot");
        }

        public boolean hasNext() {
            return this.stack.size() > 0;
        }

        public Object next() {
            if (!$assertionsDisabled && !this.hasNext()) {
                throw new AssertionError();
            }
            ++this.count;
            Object object = this.stack.pop();
            this.find();
            return object;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$benchmark$byTask$feeds$DirDocMaker == null ? (class$org$apache$lucene$benchmark$byTask$feeds$DirDocMaker = DirDocMaker.class$("org.apache.lucene.benchmark.byTask.feeds.DirDocMaker")) : class$org$apache$lucene$benchmark$byTask$feeds$DirDocMaker).desiredAssertionStatus();
        }

        static class Comparator
        implements java.util.Comparator {
            Comparator() {
            }

            public int compare(Object _a, Object _b) {
                String b;
                String a;
                block3: {
                    int diff;
                    block2: {
                        a = _a.toString();
                        b = _b.toString();
                        diff = a.length() - b.length();
                        if (diff <= 0) break block2;
                        while (diff-- > 0) {
                            b = "0" + b;
                        }
                        break block3;
                    }
                    if (diff >= 0) break block3;
                    diff = -diff;
                    while (diff-- > 0) {
                        a = "0" + a;
                    }
                }
                return b.compareTo(a);
            }
        }
    }
}

