/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.trec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.lucene.benchmark.quality.Judge;
import org.apache.lucene.benchmark.quality.QualityQuery;

public class TrecJudge
implements Judge {
    HashMap judgements = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrecJudge(BufferedReader reader) throws IOException {
        QRelJudgement curr = null;
        String zero = "0";
        try {
            String line;
            while (null != (line = reader.readLine())) {
                boolean relevant;
                if ((line = line.trim()).length() == 0 || '#' == line.charAt(0)) continue;
                StringTokenizer st = new StringTokenizer(line);
                String queryID = st.nextToken();
                st.nextToken();
                String docName = st.nextToken();
                boolean bl = relevant = !zero.equals(st.nextToken());
                if (!$assertionsDisabled && st.hasMoreTokens()) {
                    throw new AssertionError((Object)("wrong format: " + line + "  next: " + st.nextToken()));
                }
                if (!relevant) continue;
                if (!(curr != null && curr.queryID.equals(queryID) || (curr = (QRelJudgement)this.judgements.get(queryID)) != null)) {
                    curr = new QRelJudgement(queryID);
                    this.judgements.put(queryID, curr);
                }
                curr.addRelevandDoc(docName);
            }
        }
        finally {
            reader.close();
        }
    }

    public boolean isRelevant(String docName, QualityQuery query) {
        QRelJudgement qrj = (QRelJudgement)this.judgements.get(query.getQueryID());
        return qrj != null && qrj.isRelevant(docName);
    }

    public boolean validateData(QualityQuery[] qq, PrintWriter logger) {
        HashMap missingQueries = (HashMap)this.judgements.clone();
        ArrayList<String> missingJudgements = new ArrayList<String>();
        for (int i = 0; i < qq.length; ++i) {
            String id = qq[i].getQueryID();
            if (missingQueries.containsKey(id)) {
                missingQueries.remove(id);
                continue;
            }
            missingJudgements.add(id);
        }
        boolean isValid = true;
        if (missingJudgements.size() > 0) {
            isValid = false;
            if (logger != null) {
                logger.println("WARNING: " + missingJudgements.size() + " queries have no judgments! - ");
                for (int i = 0; i < missingJudgements.size(); ++i) {
                    logger.println("   " + (String)missingJudgements.get(i));
                }
            }
        }
        if (missingQueries.size() > 0) {
            isValid = false;
            if (logger != null) {
                logger.println("WARNING: " + missingQueries.size() + " judgments match no query! - ");
                Iterator it = missingQueries.keySet().iterator();
                while (it.hasNext()) {
                    String id = (String)it.next();
                    logger.println("   " + id);
                }
            }
        }
        return isValid;
    }

    public int maxRecall(QualityQuery query) {
        QRelJudgement qrj = (QRelJudgement)this.judgements.get(query.getQueryID());
        if (qrj != null) {
            return qrj.maxRecall();
        }
        return 0;
    }

    static {
        $assertionsDisabled = !TrecJudge.class.desiredAssertionStatus();
    }

    private static class QRelJudgement {
        private String queryID;
        private HashMap relevantDocs;

        QRelJudgement(String queryID) {
            this.queryID = queryID;
            this.relevantDocs = new HashMap();
        }

        public void addRelevandDoc(String docName) {
            this.relevantDocs.put(docName, docName);
        }

        boolean isRelevant(String docName) {
            return this.relevantDocs.containsKey(docName);
        }

        public int maxRecall() {
            return this.relevantDocs.size();
        }
    }
}

