/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.utils;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.tasks.RepSumByPrefTask;
import org.apache.lucene.benchmark.byTask.tasks.TaskSequence;

public class Algorithm {
    private TaskSequence sequence;

    public Algorithm(PerfRunData runData) throws Exception {
        PerfTask p;
        ArrayList t;
        String algTxt = runData.getConfig().getAlgorithmText();
        TaskSequence currSequence = this.sequence = new TaskSequence(runData, null, null, false);
        PerfTask prevTask = null;
        StreamTokenizer stok = new StreamTokenizer(new StringReader(algTxt));
        stok.commentChar(35);
        stok.eolIsSignificant(false);
        stok.ordinaryChar(34);
        stok.ordinaryChar(47);
        stok.ordinaryChar(40);
        stok.ordinaryChar(41);
        boolean colonOk = false;
        currSequence.setDepth(0);
        String taskPackage = PerfTask.class.getPackage().getName() + ".";
        Class[] paramClass = new Class[]{PerfRunData.class};
        Object[] paramObj = new PerfRunData[]{runData};
        block14: while (stok.nextToken() != -1) {
            switch (stok.ttype) {
                case -3: {
                    String s = stok.sval;
                    Constructor<?> cnstr = Class.forName(taskPackage + s + "Task").getConstructor(paramClass);
                    PerfTask task = (PerfTask)cnstr.newInstance(paramObj);
                    currSequence.addTask(task);
                    if (task instanceof RepSumByPrefTask) {
                        stok.nextToken();
                        String prefix = stok.sval;
                        if (prefix == null || prefix.length() == 0) {
                            throw new Exception("named report prefix problem - " + stok.toString());
                        }
                        ((RepSumByPrefTask)task).setPrefix(prefix);
                    }
                    stok.nextToken();
                    if (stok.ttype != 40) {
                        stok.pushBack();
                    } else {
                        StringBuffer params = new StringBuffer();
                        stok.nextToken();
                        while (stok.ttype != 41) {
                            switch (stok.ttype) {
                                case -2: {
                                    params.append(stok.nval);
                                    break;
                                }
                                case -3: {
                                    params.append(stok.sval);
                                    break;
                                }
                                case -1: {
                                    throw new Exception("unexpexted EOF: - " + stok.toString());
                                }
                                default: {
                                    params.append((char)stok.ttype);
                                }
                            }
                            stok.nextToken();
                        }
                        String prm = params.toString().trim();
                        if (prm.length() > 0) {
                            task.setParams(prm);
                        }
                    }
                    colonOk = false;
                    prevTask = task;
                    continue block14;
                }
            }
            char c = (char)stok.ttype;
            switch (c) {
                case ':': {
                    if (!colonOk) {
                        throw new Exception("colon unexpexted: - " + stok.toString());
                    }
                    colonOk = false;
                    stok.nextToken();
                    if ((char)stok.ttype == '*') {
                        ((TaskSequence)prevTask).setRepetitions(TaskSequence.REPEAT_EXHAUST);
                    } else {
                        if (stok.ttype != -2) {
                            throw new Exception("expexted repetitions number: - " + stok.toString());
                        }
                        ((TaskSequence)prevTask).setRepetitions((int)stok.nval);
                    }
                    stok.nextToken();
                    if (stok.ttype != 58) {
                        stok.pushBack();
                    } else {
                        stok.nextToken();
                        if (stok.ttype != -2) {
                            throw new Exception("expexted rate number: - " + stok.toString());
                        }
                        stok.nextToken();
                        if (stok.ttype != 47) {
                            stok.pushBack();
                            ((TaskSequence)prevTask).setRate((int)stok.nval, false);
                        } else {
                            stok.nextToken();
                            if (stok.ttype != -3) {
                                throw new Exception("expexted rate unit: 'min' or 'sec' - " + stok.toString());
                            }
                            String unit = stok.sval.toLowerCase();
                            if ("min".equals(unit)) {
                                ((TaskSequence)prevTask).setRate((int)stok.nval, true);
                            } else if ("sec".equals(unit)) {
                                ((TaskSequence)prevTask).setRate((int)stok.nval, false);
                            } else {
                                throw new Exception("expexted rate unit: 'min' or 'sec' - " + stok.toString());
                            }
                        }
                    }
                    colonOk = false;
                    break;
                }
                case '[': 
                case '{': {
                    String name = null;
                    stok.nextToken();
                    if (stok.ttype != 34) {
                        stok.pushBack();
                    } else {
                        stok.nextToken();
                        name = stok.sval;
                        stok.nextToken();
                        if (stok.ttype != 34 || name == null || name.length() == 0) {
                            throw new Exception("sequence name problem - " + stok.toString());
                        }
                    }
                    TaskSequence seq2 = new TaskSequence(runData, name, currSequence, c == '[');
                    currSequence.addTask(seq2);
                    currSequence = seq2;
                    colonOk = false;
                    break;
                }
                case '>': {
                    currSequence.setNoChildReport();
                }
                case ']': 
                case '}': {
                    colonOk = true;
                    prevTask = currSequence;
                    currSequence = currSequence.getParent();
                }
            }
        }
        if (this.sequence != currSequence) {
            throw new Exception("Unmatched sequences");
        }
        while (this.sequence.getRepetitions() == 1 && this.sequence.getRate() == 0 && (t = this.sequence.getTasks()) != null && t.size() == 1 && (p = (PerfTask)t.get(0)) instanceof TaskSequence) {
            this.sequence = (TaskSequence)p;
        }
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(this.sequence.toString());
        sb.append(newline);
        return sb.toString();
    }

    public void execute() throws Exception {
        this.sequence.doLogic();
    }

    public ArrayList extractTasks() {
        ArrayList res = new ArrayList();
        this.extractTasks(res, this.sequence);
        return res;
    }

    private void extractTasks(ArrayList extrct, TaskSequence seq) {
        if (seq == null) {
            return;
        }
        extrct.add(seq);
        ArrayList t = this.sequence.getTasks();
        if (t == null) {
            return;
        }
        for (int i = 0; i < t.size(); ++i) {
            PerfTask p = (PerfTask)t.get(0);
            if (p instanceof TaskSequence) {
                this.extractTasks(extrct, (TaskSequence)p);
                continue;
            }
            extrct.add(p);
        }
    }
}

