/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.standard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.benchmark.AbstractBenchmarker;
import org.apache.lucene.benchmark.BenchmarkOptions;
import org.apache.lucene.benchmark.Benchmarker;
import org.apache.lucene.benchmark.standard.ReutersQueries;
import org.apache.lucene.benchmark.standard.StandardOptions;
import org.apache.lucene.benchmark.stats.QueryData;
import org.apache.lucene.benchmark.stats.TestData;
import org.apache.lucene.benchmark.stats.TestRunData;
import org.apache.lucene.benchmark.stats.TimeData;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class StandardBenchmarker
extends AbstractBenchmarker
implements Benchmarker {
    public static final String SOURCE_DIR = "reuters-out";
    public static final String INDEX_DIR = "index";
    private static DateFormat format = new SimpleDateFormat("dd-MMM-yyyy kk:mm:ss.SSS", Locale.US);

    public TestData[] benchmark(File workingDir, BenchmarkOptions opts) throws Exception {
        StandardOptions options = (StandardOptions)opts;
        workingDir.mkdirs();
        File sourceDir = this.getSourceDirectory(workingDir);
        sourceDir.mkdirs();
        File indexDir = new File(workingDir, INDEX_DIR);
        indexDir.mkdirs();
        StandardAnalyzer a = new StandardAnalyzer();
        ArrayList<String> queryList = new ArrayList<String>(20);
        queryList.addAll(Arrays.asList(ReutersQueries.STANDARD_QUERIES));
        queryList.addAll(Arrays.asList(ReutersQueries.getPrebuiltQueries("body")));
        Query[] qs = StandardBenchmarker.createQueries(queryList, (Analyzer)a);
        QueryData[] qds = QueryData.getAll(qs);
        TestData[] params = TestData.getTestDataMinMaxMergeAndMaxBuffered(new File[]{sourceDir}, new Analyzer[]{a});
        System.out.println("Testing " + params.length + " different permutations.");
        for (int i = 0; i < params.length; ++i) {
            try {
                this.reset(indexDir);
                params[i].setDirectory((Directory)FSDirectory.getDirectory((File)indexDir));
                params[i].setQueries(qds);
                System.out.println(params[i]);
                this.runBenchmark(params[i], options);
                System.out.println(params[i].showRunData(params[i].getId()));
                params[i].getDirectory().close();
                System.runFinalization();
                System.gc();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("EXCEPTION: " + e.getMessage());
            }
        }
        return params;
    }

    protected File getSourceDirectory(File workingDir) {
        return new File(workingDir, SOURCE_DIR);
    }

    protected void runBenchmark(TestData params, StandardOptions options) throws Exception {
        System.out.println("Start Time: " + new Date());
        int runCount = options.getRunCount();
        for (int i = 0; i < runCount; ++i) {
            TestRunData trd = new TestRunData();
            trd.startRun();
            trd.setId(String.valueOf(i));
            IndexWriter iw = new IndexWriter(params.getDirectory(), params.getAnalyzer(), true);
            iw.setMergeFactor(params.getMergeFactor());
            iw.setMaxBufferedDocs(params.getMaxBufferedDocs());
            iw.setUseCompoundFile(params.isCompound());
            this.makeIndex(trd, params.getSource(), iw, true, true, false, options);
            if (params.isOptimize()) {
                TimeData td = new TimeData("optimize");
                trd.addData(td);
                td.start();
                iw.optimize();
                td.stop();
                trd.addData(td);
            }
            iw.close();
            QueryData[] queries = params.getQueries();
            if (queries != null) {
                IndexReader ir = null;
                IndexSearcher searcher = null;
                for (int k = 0; k < queries.length; ++k) {
                    TimeData td;
                    QueryData qd = queries[k];
                    if (ir != null && qd.reopen) {
                        searcher.close();
                        ir.close();
                        ir = null;
                        searcher = null;
                    }
                    if (ir == null) {
                        ir = IndexReader.open((Directory)params.getDirectory());
                        searcher = new IndexSearcher(ir);
                    }
                    Document doc = null;
                    if (qd.warmup) {
                        td = new TimeData(qd.id + "-warm");
                        for (int m = 0; m < ir.maxDoc(); ++m) {
                            td.start();
                            if (ir.isDeleted(m)) {
                                td.stop();
                                continue;
                            }
                            doc = ir.document(m);
                            td.stop();
                        }
                        trd.addData(td);
                    }
                    td = new TimeData(qd.id + "-srch");
                    td.start();
                    Hits h = searcher.search(qd.q);
                    td.stop();
                    trd.addData(td);
                    td = new TimeData(qd.id + "-trav");
                    if (h != null && h.length() > 0) {
                        for (int m = 0; m < h.length(); ++m) {
                            td.start();
                            int id = h.id(m);
                            if (qd.retrieve) {
                                doc = ir.document(id);
                            }
                            td.stop();
                        }
                    }
                    trd.addData(td);
                }
                try {
                    if (searcher != null) {
                        searcher.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (ir != null) {
                        ir.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            trd.endRun();
            params.getRunData().add(trd);
        }
        System.out.println("End Time: " + new Date());
    }

    protected Document makeDocument(File in, String[] tags, boolean stored, boolean tokenized, boolean tfv) throws Exception {
        Document doc = new Document();
        if (tags != null) {
            for (int i = 0; i < tags.length; ++i) {
                doc.add((Fieldable)new Field("tag" + i, tags[i], stored ? Field.Store.YES : Field.Store.NO, tokenized ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED, tfv ? Field.TermVector.YES : Field.TermVector.NO));
            }
        }
        doc.add((Fieldable)new Field("file", in.getCanonicalPath(), stored ? Field.Store.YES : Field.Store.NO, tokenized ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED, tfv ? Field.TermVector.YES : Field.TermVector.NO));
        BufferedReader reader = new BufferedReader(new FileReader(in));
        String line = null;
        String dateStr = reader.readLine();
        reader.readLine();
        String title = reader.readLine();
        reader.readLine();
        StringBuffer body = new StringBuffer(1024);
        while ((line = reader.readLine()) != null) {
            body.append(line).append(' ');
        }
        reader.close();
        Date date = format.parse(dateStr.trim());
        doc.add((Fieldable)new Field("date", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.UN_TOKENIZED));
        if (title != null) {
            doc.add((Fieldable)new Field("title", title, stored ? Field.Store.YES : Field.Store.NO, tokenized ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED, tfv ? Field.TermVector.YES : Field.TermVector.NO));
        }
        if (body.length() > 0) {
            doc.add((Fieldable)new Field("body", body.toString(), stored ? Field.Store.YES : Field.Store.NO, tokenized ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED, tfv ? Field.TermVector.YES : Field.TermVector.NO));
        }
        return doc;
    }

    protected void makeIndex(TestRunData trd, File srcDir, IndexWriter iw, boolean stored, boolean tokenized, boolean tfv, StandardOptions options) throws Exception {
        ArrayList files = new ArrayList();
        StandardBenchmarker.getAllFiles(srcDir, null, files);
        Document doc = null;
        long cnt = 0L;
        TimeData td = new TimeData();
        td.name = "addDocument";
        int scaleUp = options.getScaleUp();
        int logStep = options.getLogStep();
        int max = Math.min(files.size(), options.getMaximumDocumentsToIndex());
        for (int s = 0; s < scaleUp; ++s) {
            String[] tags = new String[]{srcDir.getName() + "/" + s};
            Iterator iterator = files.iterator();
            for (int i = 0; iterator.hasNext() && i < max; ++i) {
                File file = (File)iterator.next();
                doc = this.makeDocument(file, tags, stored, tokenized, tfv);
                td.start();
                iw.addDocument(doc);
                td.stop();
                if (++cnt % (long)logStep != 0L) continue;
                System.err.println(" - processed " + cnt + ", run id=" + trd.getId());
                trd.addData(td);
                td.reset();
            }
        }
        trd.addData(td);
    }

    public static void getAllFiles(File srcDir, FileFilter filter, List allFiles) {
        File[] files = srcDir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                StandardBenchmarker.getAllFiles(file, filter, allFiles);
                continue;
            }
            allFiles.add(file);
        }
    }

    public static Query[] createQueries(List qs, Analyzer a) {
        QueryParser qp = new QueryParser("body", a);
        ArrayList<Query> queries = new ArrayList<Query>();
        for (int i = 0; i < qs.size(); ++i) {
            try {
                Object query = qs.get(i);
                Query q = null;
                if (query instanceof String) {
                    q = qp.parse((String)query);
                } else if (query instanceof Query) {
                    q = (Query)query;
                } else {
                    System.err.println("Unsupported Query Type: " + query);
                }
                if (q == null) continue;
                queries.add(q);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return queries.toArray(new Query[0]);
    }

    protected void reset(File indexDir) throws Exception {
        if (indexDir.exists()) {
            StandardBenchmarker.fullyDelete(indexDir);
        }
        indexDir.mkdirs();
    }

    protected void saveStream(InputStream is, File out, boolean closeInput) throws Exception {
        long time;
        byte[] buf = new byte[4096];
        FileOutputStream fos = new FileOutputStream(out);
        int len = 0;
        long total = 0L;
        long delta = time = System.currentTimeMillis();
        while ((len = is.read(buf)) > 0) {
            fos.write(buf, 0, len);
            total += (long)len;
            time = System.currentTimeMillis();
            if (time - delta <= 5000L) continue;
            System.err.println(" - copied " + total / 1024L + " kB...");
            delta = time;
        }
        fos.flush();
        fos.close();
        if (closeInput) {
            is.close();
        }
    }

    static {
        format.setLenient(true);
    }
}

