/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;

public abstract class ReadTask
extends PerfTask {
    public ReadTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws Exception {
        int res = 0;
        boolean closeReader = false;
        IndexReader ir = this.getRunData().getIndexReader();
        if (ir == null) {
            Directory dir = this.getRunData().getDirectory();
            ir = IndexReader.open((Directory)dir);
            closeReader = true;
        }
        if (this.withWarm()) {
            Document doc = null;
            for (int m = 0; m < ir.maxDoc(); ++m) {
                if (ir.isDeleted(m)) continue;
                doc = ir.document(m);
                res += doc == null ? 0 : 1;
            }
        }
        if (this.withSearch()) {
            int traversalSize;
            ++res;
            IndexSearcher searcher = new IndexSearcher(ir);
            QueryMaker queryMaker = this.getQueryMaker();
            Query q = queryMaker.makeQuery();
            Hits hits = searcher.search(q);
            if (this.withTraverse() && hits != null && (traversalSize = Math.min(hits.length(), this.traversalSize())) > 0) {
                boolean retrieve = this.withRetrieve();
                for (int m = 0; m < hits.length(); ++m) {
                    int id = hits.id(m);
                    ++res;
                    if (!retrieve) continue;
                    res += this.retrieveDoc(ir, id);
                }
            }
            searcher.close();
        }
        if (closeReader) {
            ir.close();
        }
        return res;
    }

    protected int retrieveDoc(IndexReader ir, int id) throws IOException {
        return ir.document(id) == null ? 0 : 1;
    }

    public abstract QueryMaker getQueryMaker();

    public abstract boolean withSearch();

    public abstract boolean withWarm();

    public abstract boolean withTraverse();

    public int traversalSize() {
        return Integer.MAX_VALUE;
    }

    public abstract boolean withRetrieve();
}

