/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;

public class AddDocTask
extends PerfTask {
    public static final int DEFAULT_ADD_DOC_LOG_STEP = 500;
    private static int logStep = -1;
    private int docSize = 0;
    private Document doc = null;

    public AddDocTask(PerfRunData runData) {
        super(runData);
    }

    public void setup() throws Exception {
        super.setup();
        DocMaker docMaker = this.getRunData().getDocMaker();
        this.doc = this.docSize > 0 ? docMaker.makeDocument(this.docSize) : docMaker.makeDocument();
    }

    public void tearDown() throws Exception {
        DocMaker docMaker = this.getRunData().getDocMaker();
        this.log(docMaker.getCount());
        this.doc = null;
        super.tearDown();
    }

    public int doLogic() throws Exception {
        this.getRunData().getIndexWriter().addDocument(this.doc);
        return 1;
    }

    private void log(int count) {
        if (logStep < 0) {
            logStep = this.getRunData().getConfig().get("doc.add.log.step", 500);
        }
        if (logStep > 0 && count % logStep == 0) {
            System.out.println("--> processed (add) " + count + " docs");
        }
    }

    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    public boolean supportsParams() {
        return true;
    }
}

