/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.lucene.benchmark.byTask.feeds.SimpleQueryMaker;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class SimpleSloppyPhraseQueryMaker
extends SimpleQueryMaker {
    protected Query[] prepareQueries() throws Exception {
        ArrayList<String> w = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer("Well it may be a little dramatic but sometimes it true. If you call the emergency medical services to an incident, your actions have started the chain of survival. You have acted to help someone you may not even know. First aid is helping, first aid is making that call, putting a Band-Aid on a small wound, controlling bleeding in large wounds or providing CPR for a collapsed person whose not breathing and heart has stopped beating. You can help yourself, your loved ones and the stranger whose life may depend on you being in the right place at the right time with the right knowledge.");
        while (st.hasMoreTokens() && w.size() < 100) {
            w.add(st.nextToken());
        }
        String[] words = w.toArray(new String[0]);
        ArrayList<PhraseQuery> queries = new ArrayList<PhraseQuery>();
        for (int slop = 0; slop < 8; ++slop) {
            for (int qlen = 2; qlen < 6; ++qlen) {
                for (int wd = 0; wd < words.length - qlen - slop; ++wd) {
                    int i;
                    int remainedSlop = slop;
                    PhraseQuery q = new PhraseQuery();
                    q.setSlop(slop);
                    int wind = wd;
                    for (i = 0; i < qlen; ++i) {
                        q.add(new Term("body", words[wind++]));
                        if (remainedSlop <= 0) continue;
                        --remainedSlop;
                        ++wind;
                    }
                    queries.add(q);
                    remainedSlop = slop;
                    q = new PhraseQuery();
                    q.setSlop(slop + 2 * qlen);
                    wind = wd + qlen + remainedSlop - 1;
                    for (i = 0; i < qlen; ++i) {
                        q.add(new Term("body", words[wind--]));
                        if (remainedSlop <= 0) continue;
                        --remainedSlop;
                        --wind;
                    }
                    queries.add(q);
                }
            }
        }
        return queries.toArray(new Query[0]);
    }
}

