/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.benchmark.byTask.feeds.BasicDocMaker;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class ReutersDocMaker
extends BasicDocMaker {
    private DateFormat dateFormat;
    private File dataDir = null;
    private ArrayList inputFiles = new ArrayList();
    private int nextFile = 0;
    private int iteration = 0;

    public void setConfig(Config config) {
        super.setConfig(config);
        String d = config.get("docs.dir", "reuters-out");
        this.dataDir = new File(new File("work"), d);
        this.collectFiles(this.dataDir, this.inputFiles);
        if (this.inputFiles.size() == 0) {
            throw new RuntimeException("No txt files in dataDir: " + this.dataDir.getAbsolutePath());
        }
        this.dateFormat = new SimpleDateFormat("dd-MMM-yyyy kk:mm:ss.SSS", Locale.US);
        this.dateFormat.setLenient(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocData getNextDocData() throws Exception {
        File f = null;
        String name = null;
        ReutersDocMaker reutersDocMaker = this;
        synchronized (reutersDocMaker) {
            if (this.nextFile >= this.inputFiles.size()) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.nextFile = 0;
                ++this.iteration;
            }
            f = (File)this.inputFiles.get(this.nextFile++);
            name = f.getCanonicalPath() + "_" + this.iteration;
        }
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = null;
        String dateStr = reader.readLine();
        reader.readLine();
        String title = reader.readLine();
        reader.readLine();
        StringBuffer bodyBuf = new StringBuffer(1024);
        while ((line = reader.readLine()) != null) {
            bodyBuf.append(line).append(' ');
        }
        reader.close();
        this.addBytes(f.length());
        Date date = this.dateFormat.parse(dateStr.trim());
        return new DocData(name, bodyBuf.toString(), title, null, date);
    }

    public synchronized void resetInputs() {
        super.resetInputs();
        this.nextFile = 0;
        this.iteration = 0;
    }

    public int numUniqueTexts() {
        return this.inputFiles.size();
    }
}

