/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.HTMLParser;

public class DemoHTMLParser
implements HTMLParser {
    DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss ", Locale.US);

    public DemoHTMLParser() {
        this.dateFormat.setLenient(true);
    }

    public DocData parse(String name, Date date, Reader reader, DateFormat dateFormat) throws IOException, InterruptedException {
        int n;
        org.apache.lucene.demo.html.HTMLParser p = new org.apache.lucene.demo.html.HTMLParser(reader);
        String title = p.getTitle();
        Properties props = p.getMetaTags();
        Reader r = p.getReader();
        char[] c = new char[1024];
        StringBuffer bodyBuf = new StringBuffer();
        while ((n = r.read(c)) >= 0) {
            if (n <= 0) continue;
            bodyBuf.append(c, 0, n);
        }
        r.close();
        if (date == null && props.getProperty("date") != null) {
            try {
                date = dateFormat.parse(props.getProperty("date").trim());
            }
            catch (ParseException e) {
                System.out.println("ignoring date parse exception (assigning 'now') for: " + props.getProperty("date"));
                date = new Date();
            }
        }
        return new DocData(name, bodyBuf.toString(), title, props, date);
    }

    public DocData parse(String name, Date date, StringBuffer inputText, DateFormat dateFormat) throws IOException, InterruptedException {
        return this.parse(name, date, new StringReader(inputText.toString()), dateFormat);
    }
}

