/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene95.OffHeapByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=4, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=3, jvmArgsAppend={"-Xmx2g", "-Xms2g", "-XX:+AlwaysPreTouch"})
public class VectorScorerBenchmark {
    @Param(value={"1", "128", "207", "256", "300", "512", "702", "1024"})
    int size;
    Directory dir;
    IndexInput in;
    KnnVectorValues vectorValues;
    byte[] vec1;
    byte[] vec2;
    RandomVectorScorer scorer;

    @Setup(value=Level.Iteration)
    public void init() throws IOException {
        this.vec1 = new byte[this.size];
        this.vec2 = new byte[this.size];
        ThreadLocalRandom.current().nextBytes(this.vec1);
        ThreadLocalRandom.current().nextBytes(this.vec2);
        this.dir = new MMapDirectory(Files.createTempDirectory("VectorScorerBenchmark", new FileAttribute[0]));
        try (IndexOutput out = this.dir.createOutput("vector.data", IOContext.DEFAULT);){
            out.writeBytes(this.vec1, 0, this.vec1.length);
            out.writeBytes(this.vec2, 0, this.vec2.length);
        }
        this.in = this.dir.openInput("vector.data", IOContext.DEFAULT);
        this.vectorValues = VectorScorerBenchmark.vectorValues(this.size, 2, this.in, VectorSimilarityFunction.DOT_PRODUCT);
        this.scorer = FlatVectorScorerUtil.getLucene99FlatVectorsScorer().getRandomVectorScorerSupplier(VectorSimilarityFunction.DOT_PRODUCT, this.vectorValues).scorer(0);
    }

    @TearDown
    public void teardown() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.dir, this.in});
    }

    @Benchmark
    public float binaryDotProductDefault() throws IOException {
        return this.scorer.score(1);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public float binaryDotProductMemSeg() throws IOException {
        return this.scorer.score(1);
    }

    static KnnVectorValues vectorValues(int dims, int size, IndexInput in, VectorSimilarityFunction sim) throws IOException {
        return new OffHeapByteVectorValues.DenseOffHeapVectorValues(dims, size, in.slice("test", 0L, in.length()), dims, (FlatVectorsScorer)new ThrowingFlatVectorScorer(), sim);
    }

    static final class ThrowingFlatVectorScorer
    implements FlatVectorsScorer {
        ThrowingFlatVectorScorer() {
        }

        public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) {
            throw new UnsupportedOperationException();
        }

        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) {
            throw new UnsupportedOperationException();
        }

        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, byte[] target) {
            throw new UnsupportedOperationException();
        }
    }
}

