/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.search.DoubleValues;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=5, time=5)
@Measurement(iterations=12, time=8)
@Fork(value=1)
public class ExpressionsBenchmark {
    private static final Map<String, MethodHandle> FUNCTIONS = ExpressionsBenchmark.getFunctions();
    private static final String NATIVE_IDENTITY_NAME = "native_identity";
    private static final Expression NATIVE_IDENTITY_EXPRESSION = new Expression("native_identity", new String[]{"x"}){

        public double evaluate(DoubleValues[] functionValues) throws IOException {
            return functionValues[0].doubleValue();
        }
    };
    private double[] randomData;
    private Expression expression;
    @Param(value={"x", "func_identity(x)", "mh_identity", "native_identity", "cos(x)", "cos(x) + sin(x)"})
    String js;

    private static Map<String, MethodHandle> getFunctions() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            HashMap<String, MethodHandle> m = new HashMap<String, MethodHandle>(JavascriptCompiler.DEFAULT_FUNCTIONS);
            m.put("func_identity", lookup.findStatic(lookup.lookupClass(), "ident", MethodType.methodType(Double.TYPE, Double.TYPE)));
            m.put("mh_identity", MethodHandles.identity(Double.TYPE));
            return Collections.unmodifiableMap(m);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static double ident(double v) {
        return v;
    }

    @Setup(value=Level.Iteration)
    public void init() throws ParseException {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.randomData = random.doubles().limit(1024L).toArray();
        this.expression = Objects.equals(this.js, NATIVE_IDENTITY_NAME) ? NATIVE_IDENTITY_EXPRESSION : JavascriptCompiler.compile((String)this.js, FUNCTIONS);
    }

    @Benchmark
    public double expression() throws IOException {
        ValuesIterator it = new ValuesIterator(this.randomData);
        DoubleValues[] values = it.getDoubleValues();
        double result = 0.0;
        while (it.next()) {
            result += this.expression.evaluate(values);
        }
        return result;
    }

    static final class ValuesIterator {
        final double[] data;
        final DoubleValues[] dv;
        int pos = -1;

        ValuesIterator(final double[] data) {
            this.data = data;
            DoubleValues dv = new DoubleValues(){

                public double doubleValue() throws IOException {
                    return data[pos];
                }

                public boolean advanceExact(int doc) throws IOException {
                    throw new UnsupportedOperationException();
                }
            };
            this.dv = new DoubleValues[]{dv};
        }

        boolean next() {
            ++this.pos;
            return this.pos < this.data.length;
        }

        DoubleValues[] getDoubleValues() {
            return this.dv;
        }
    }
}

