/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.je;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.je.Block;
import org.apache.lucene.store.je.File;
import org.apache.lucene.store.je.JEDirectory;

public class JEIndexOutput
extends IndexOutput {
    public static final int BLOCK_SHIFT = 14;
    public static final int BLOCK_LEN = 16384;
    public static final int BLOCK_MASK = 16383;
    protected long position = 0L;
    protected long length = 0L;
    protected JEDirectory directory;
    protected Block block;
    protected File file;

    protected JEIndexOutput(JEDirectory directory, String name, boolean create) throws IOException {
        this.directory = directory;
        this.file = new File(directory, name, create);
        this.block = new Block(this.file);
        this.length = this.file.getLength();
        this.seek(this.length);
        this.block.get(directory);
        directory.openFiles.add(this);
    }

    public void close() throws IOException {
        this.flush();
        this.file.modify(this.directory, this.length, System.currentTimeMillis());
        this.directory.openFiles.remove((Object)this);
    }

    public void flush() throws IOException {
        if (this.length > 0L) {
            this.block.put(this.directory);
        }
    }

    public void writeByte(byte b) throws IOException {
        int blockPos = (int)(this.position++ & 0x3FFFL);
        this.block.getData()[blockPos] = b;
        if (blockPos + 1 == 16384) {
            this.block.put(this.directory);
            this.block.seek(this.position);
            this.block.get(this.directory);
        }
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        int blockPos = (int)(this.position & 0x3FFFL);
        while (blockPos + len >= 16384) {
            int blockLen = 16384 - blockPos;
            System.arraycopy(b, offset, this.block.getData(), blockPos, blockLen);
            this.block.put(this.directory);
            len -= blockLen;
            offset += blockLen;
            this.position += (long)blockLen;
            this.block.seek(this.position);
            this.block.get(this.directory);
            blockPos = 0;
        }
        if (len > 0) {
            System.arraycopy(b, offset, this.block.getData(), blockPos, len);
            this.position += (long)len;
        }
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public long length() throws IOException {
        return this.length;
    }

    public void seek(long pos) throws IOException {
        if (pos > this.length) {
            throw new IOException("seeking past end of file");
        }
        if (pos >>> 14 == this.position >>> 14) {
            this.position = pos;
        } else {
            this.block.put(this.directory);
            this.block.seek(pos);
            this.block.get(this.directory);
            this.position = pos;
        }
    }

    public long getFilePointer() {
        return this.position;
    }
}

