/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene42;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
final class Lucene42DocValuesProducer
extends DocValuesProducer {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, FSTEntry> fsts;
    private final IndexInput data;
    private final int version;
    private final int numEntries;
    private final Map<String, NumericDocValues> numericInstances;
    private final Map<String, BinaryDocValues> binaryInstances;
    private final Map<String, FST<Long>> fstInstances;
    private final Map<String, Accountable> numericInfo;
    private final Map<String, Accountable> binaryInfo;
    private final Map<String, Accountable> addressInfo;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte FST = 2;
    static final int BLOCK_SIZE = 4096;
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte UNCOMPRESSED = 2;
    static final byte GCD_COMPRESSED = 3;
    static final int VERSION_START = 0;
    static final int VERSION_GCD_COMPRESSION = 1;
    static final int VERSION_CHECKSUM = 2;
    static final int VERSION_CURRENT = 2;
    private final boolean merging;

    Lucene42DocValuesProducer(Lucene42DocValuesProducer original) throws IOException {
        this.numericInstances = new HashMap<String, NumericDocValues>();
        this.binaryInstances = new HashMap<String, BinaryDocValues>();
        this.fstInstances = new HashMap<String, FST<Long>>();
        this.numericInfo = new HashMap<String, Accountable>();
        this.binaryInfo = new HashMap<String, Accountable>();
        this.addressInfo = new HashMap<String, Accountable>();
        assert (Thread.holdsLock((Object)original));
        this.numerics = original.numerics;
        this.binaries = original.binaries;
        this.fsts = original.fsts;
        this.data = original.data.clone();
        this.version = original.version;
        this.numEntries = original.numEntries;
        this.numericInstances.putAll(original.numericInstances);
        this.binaryInstances.putAll(original.binaryInstances);
        this.fstInstances.putAll(original.fstInstances);
        this.numericInfo.putAll(original.numericInfo);
        this.binaryInfo.putAll(original.binaryInfo);
        this.addressInfo.putAll(original.addressInfo);
        this.maxDoc = original.maxDoc;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene42DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block11: {
            ChecksumIndexInput in;
            block10: {
                this.numericInstances = new HashMap<String, NumericDocValues>();
                this.binaryInstances = new HashMap<String, BinaryDocValues>();
                this.fstInstances = new HashMap<String, FST<Long>>();
                this.numericInfo = new HashMap<String, Accountable>();
                this.binaryInfo = new HashMap<String, Accountable>();
                this.addressInfo = new HashMap<String, Accountable>();
                this.maxDoc = state.segmentInfo.getDocCount();
                this.merging = false;
                String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
                in = state.directory.openChecksumInput(metaName, state.context);
                success = false;
                this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(((Object)((Object)this)).getClass()));
                try {
                    this.version = CodecUtil.checkHeader((DataInput)in, (String)metaCodec, (int)0, (int)2);
                    this.numerics = new HashMap<String, NumericEntry>();
                    this.binaries = new HashMap<String, BinaryEntry>();
                    this.fsts = new HashMap<String, FSTEntry>();
                    this.numEntries = this.readFields((IndexInput)in, state.fieldInfos);
                    if (this.version >= 2) {
                        CodecUtil.checkFooter((ChecksumIndexInput)in);
                    } else {
                        CodecUtil.checkEOF((IndexInput)in);
                    }
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block11;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        success = false;
        try {
            int version2 = CodecUtil.checkHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)2);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + this.version + ", data=" + version2, (DataInput)this.data);
            }
            if (this.version >= 2) {
                CodecUtil.retrieveChecksum((IndexInput)this.data);
            }
            if (success = true) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
    }

    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numEntries = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            ++numEntries;
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                entry = new NumericEntry();
                ((NumericEntry)entry).offset = meta.readLong();
                ((NumericEntry)entry).format = meta.readByte();
                switch (((NumericEntry)entry).format) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("Unknown format: " + ((NumericEntry)entry).format, (DataInput)meta);
                    }
                }
                if (((NumericEntry)entry).format != 2) {
                    ((NumericEntry)entry).packedIntsVersion = meta.readVInt();
                }
                this.numerics.put(info.name, (NumericEntry)entry);
            } else if (fieldType == 1) {
                entry = new BinaryEntry();
                ((BinaryEntry)entry).offset = meta.readLong();
                ((BinaryEntry)entry).numBytes = meta.readLong();
                ((BinaryEntry)entry).minLength = meta.readVInt();
                ((BinaryEntry)entry).maxLength = meta.readVInt();
                if (((BinaryEntry)entry).minLength != ((BinaryEntry)entry).maxLength) {
                    ((BinaryEntry)entry).packedIntsVersion = meta.readVInt();
                    ((BinaryEntry)entry).blockSize = meta.readVInt();
                }
                this.binaries.put(info.name, (BinaryEntry)entry);
            } else if (fieldType == 2) {
                entry = new FSTEntry();
                ((FSTEntry)entry).offset = meta.readLong();
                ((FSTEntry)entry).numOrds = meta.readVLong();
                this.fsts.put(info.name, (FSTEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType, (DataInput)meta);
            }
            fieldNumber = meta.readVInt();
        }
        return numEntries;
    }

    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field.name);
        if (instance == null) {
            instance = this.loadNumeric(field);
            if (!this.merging) {
                this.numericInstances.put(field.name, instance);
            }
        }
        return instance;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    public synchronized Collection<Accountable> getChildResources() {
        ArrayList resources = new ArrayList();
        resources.addAll(Accountables.namedAccountables((String)"numeric field", this.numericInfo));
        resources.addAll(Accountables.namedAccountables((String)"binary field", this.binaryInfo));
        resources.addAll(Accountables.namedAccountables((String)"addresses field", this.addressInfo));
        resources.addAll(Accountables.namedAccountables((String)"terms dict field", this.fstInstances));
        return Collections.unmodifiableList(resources);
    }

    public void checkIntegrity() throws IOException {
        if (this.version >= 2) {
            CodecUtil.checksumEntireFile((IndexInput)this.data);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(entries=" + this.numEntries + ")";
    }

    private NumericDocValues loadNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        this.data.seek(entry.offset);
        switch (entry.format) {
            case 1: {
                int size = this.data.readVInt();
                if (size > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + size, (DataInput)this.data);
                }
                final long[] decode = new long[size];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader((DataInput)this.data, (PackedInts.Format)PackedInts.Format.byId((int)formatID), (int)entry.packedIntsVersion, (int)this.maxDoc, (int)bitsPerValue);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((long[])decode) + ordsReader.ramBytesUsed());
                    this.numericInfo.put(field.name, (Accountable)ordsReader);
                }
                return new NumericDocValues(){

                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
            case 0: {
                int blockSize = this.data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(this.data, entry.packedIntsVersion, blockSize, (long)this.maxDoc, false);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
                    this.numericInfo.put(field.name, (Accountable)reader);
                }
                return reader;
            }
            case 2: {
                final byte[] bytes = new byte[this.maxDoc];
                this.data.readBytes(bytes, 0, bytes.length);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((byte[])bytes));
                    this.numericInfo.put(field.name, Accountables.namedAccountable((String)"byte array", (long)this.maxDoc));
                }
                return new NumericDocValues(){

                    public long get(int docID) {
                        return bytes[docID];
                    }
                };
            }
            case 3: {
                final long min = this.data.readLong();
                final long mult = this.data.readLong();
                int quotientBlockSize = this.data.readVInt();
                final BlockPackedReader quotientReader = new BlockPackedReader(this.data, entry.packedIntsVersion, quotientBlockSize, (long)this.maxDoc, false);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(quotientReader.ramBytesUsed());
                    this.numericInfo.put(field.name, (Accountable)quotientReader);
                }
                return new NumericDocValues(){

                    public long get(int docID) {
                        return min + mult * quotientReader.get(docID);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field.name);
        if (instance == null) {
            instance = this.loadBinary(field);
            if (!this.merging) {
                this.binaryInstances.put(field.name, instance);
            }
        }
        return instance;
    }

    private BinaryDocValues loadBinary(FieldInfo field) throws IOException {
        BinaryEntry entry = this.binaries.get(field.name);
        this.data.seek(entry.offset);
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(this.data, entry.numBytes);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        if (!this.merging) {
            this.binaryInfo.put(field.name, (Accountable)bytesReader);
        }
        if (entry.minLength == entry.maxLength) {
            final int fixedLength = entry.minLength;
            if (!this.merging) {
                this.ramBytesUsed.addAndGet(bytesReader.ramBytesUsed());
            }
            return new BinaryDocValues(){

                public BytesRef get(int docID) {
                    BytesRef term = new BytesRef();
                    bytesReader.fillSlice(term, (long)fixedLength * (long)docID, fixedLength);
                    return term;
                }
            };
        }
        final MonotonicBlockPackedReader addresses = MonotonicBlockPackedReader.of((IndexInput)this.data, (int)entry.packedIntsVersion, (int)entry.blockSize, (long)this.maxDoc, (boolean)false);
        if (!this.merging) {
            this.addressInfo.put(field.name, (Accountable)addresses);
            this.ramBytesUsed.addAndGet(bytesReader.ramBytesUsed() + addresses.ramBytesUsed());
        }
        return new BinaryDocValues(){

            public BytesRef get(int docID) {
                long startAddress = docID == 0 ? 0L : addresses.get(docID - 1);
                long endAddress = addresses.get(docID);
                BytesRef term = new BytesRef();
                bytesReader.fillSlice(term, startAddress, (int)(endAddress - startAddress));
                return term;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        FST instance;
        final FSTEntry entry = this.fsts.get(field.name);
        Lucene42DocValuesProducer lucene42DocValuesProducer = this;
        synchronized (lucene42DocValuesProducer) {
            instance = this.fstInstances.get(field.name);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST((DataInput)this.data, (Outputs)PositiveIntOutputs.getSingleton());
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                    this.fstInstances.put(field.name, (FST<Long>)instance);
                }
            }
        }
        final NumericDocValues docToOrd = this.getNumeric(field);
        final FST fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(fst);
        return new SortedDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();

            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            public BytesRef lookupOrd(int ord) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput((FST)fst, (long)ord, (FST.BytesReader)in, (FST.Arc)firstArc, (FST.Arc)scratchArc, (IntsRefBuilder)scratchInts);
                    this.term.grow(output.length);
                    this.term.clear();
                    return Util.toBytesRef((IntsRef)output, (BytesRefBuilder)this.term);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public int lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1;
                    }
                    if (o.input.equals((Object)key)) {
                        return ((Long)o.output).intValue();
                    }
                    return (int)(-((Long)o.output).longValue()) - 1;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public int getValueCount() {
                return (int)entry.numOrds;
            }

            public TermsEnum termsEnum() {
                return new FSTTermsEnum((FST<Long>)fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        FST instance;
        final FSTEntry entry = this.fsts.get(field.name);
        if (entry.numOrds == 0L) {
            return DocValues.emptySortedSet();
        }
        Lucene42DocValuesProducer lucene42DocValuesProducer = this;
        synchronized (lucene42DocValuesProducer) {
            instance = this.fstInstances.get(field.name);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST((DataInput)this.data, (Outputs)PositiveIntOutputs.getSingleton());
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                    this.fstInstances.put(field.name, (FST<Long>)instance);
                }
            }
        }
        final BinaryDocValues docToOrds = this.getBinary(field);
        final FST fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(fst);
        final ByteArrayDataInput input = new ByteArrayDataInput();
        return new SortedSetDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();
            BytesRef ordsRef;
            long currentOrd;

            public long nextOrd() {
                if (input.eof()) {
                    return -1L;
                }
                this.currentOrd += input.readVLong();
                return this.currentOrd;
            }

            public void setDocument(int docID) {
                this.ordsRef = docToOrds.get(docID);
                input.reset(this.ordsRef.bytes, this.ordsRef.offset, this.ordsRef.length);
                this.currentOrd = 0L;
            }

            public BytesRef lookupOrd(long ord) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput((FST)fst, (long)ord, (FST.BytesReader)in, (FST.Arc)firstArc, (FST.Arc)scratchArc, (IntsRefBuilder)scratchInts);
                    this.term.grow(output.length);
                    this.term.clear();
                    return Util.toBytesRef((IntsRef)output, (BytesRefBuilder)this.term);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public long lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1L;
                    }
                    if (o.input.equals((Object)key)) {
                        return ((Long)o.output).intValue();
                    }
                    return -((Long)o.output).longValue() - 1L;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public long getValueCount() {
                return entry.numOrds;
            }

            public TermsEnum termsEnum() {
                return new FSTTermsEnum((FST<Long>)fst);
            }
        };
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        if (field.getDocValuesType() == DocValuesType.SORTED_SET) {
            return DocValues.docsWithValue((SortedSetDocValues)this.getSortedSet(field), (int)this.maxDoc);
        }
        return new Bits.MatchAllBits(this.maxDoc);
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        throw new IllegalStateException("Lucene 4.2 does not support SortedNumeric: how did you pull this off?");
    }

    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new Lucene42DocValuesProducer(this);
    }

    public void close() throws IOException {
        this.data.close();
    }

    static class FSTTermsEnum
    extends TermsEnum {
        final BytesRefFSTEnum<Long> in;
        final FST<Long> fst;
        final FST.BytesReader bytesReader;
        final FST.Arc<Long> firstArc = new FST.Arc();
        final FST.Arc<Long> scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefBuilder scratchBytes = new BytesRefBuilder();

        FSTTermsEnum(FST<Long> fst) {
            this.fst = fst;
            this.in = new BytesRefFSTEnum(fst);
            this.bytesReader = fst.getBytesReader();
        }

        public BytesRef next() throws IOException {
            BytesRefFSTEnum.InputOutput io = this.in.next();
            if (io == null) {
                return null;
            }
            return io.input;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            if (this.in.seekCeil(text) == null) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.term().equals((Object)text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public boolean seekExact(BytesRef text) throws IOException {
            return this.in.seekExact(text) != null;
        }

        public void seekExact(long ord) throws IOException {
            this.bytesReader.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            IntsRef output = Util.getByOutput(this.fst, (long)ord, (FST.BytesReader)this.bytesReader, this.firstArc, this.scratchArc, (IntsRefBuilder)this.scratchInts);
            BytesRefBuilder scratchBytes = new BytesRefBuilder();
            scratchBytes.clear();
            Util.toBytesRef((IntsRef)output, (BytesRefBuilder)scratchBytes);
            this.in.seekExact(scratchBytes.get());
        }

        public BytesRef term() throws IOException {
            return this.in.current().input;
        }

        public long ord() throws IOException {
            return (Long)this.in.current().output;
        }

        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        byte format;
        int packedIntsVersion;

        NumericEntry() {
        }
    }
}

