/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.uima.BaseUIMATokenizer;
import org.apache.lucene.util.AttributeFactory;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;

public final class UIMATypeAwareAnnotationsTokenizer
extends BaseUIMATokenizer {
    private final TypeAttribute typeAttr;
    private final CharTermAttribute termAttr;
    private final OffsetAttribute offsetAttr;
    private final String tokenTypeString;
    private final String typeAttributeFeaturePath;
    private FeaturePath featurePath;
    private int finalOffset = 0;

    public UIMATypeAwareAnnotationsTokenizer(String descriptorPath, String tokenType, String typeAttributeFeaturePath, Map<String, Object> configurationParameters) {
        this(descriptorPath, tokenType, typeAttributeFeaturePath, configurationParameters, DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
    }

    public UIMATypeAwareAnnotationsTokenizer(String descriptorPath, String tokenType, String typeAttributeFeaturePath, Map<String, Object> configurationParameters, AttributeFactory factory) {
        super(factory, descriptorPath, configurationParameters);
        this.tokenTypeString = tokenType;
        this.termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.typeAttr = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        this.offsetAttr = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAttributeFeaturePath = typeAttributeFeaturePath;
    }

    @Override
    protected void initializeIterator() throws IOException {
        try {
            this.analyzeInput();
        }
        catch (AnalysisEngineProcessException e) {
            throw new IOException(e);
        }
        catch (ResourceInitializationException e) {
            throw new IOException(e);
        }
        this.featurePath = this.cas.createFeaturePath();
        try {
            this.featurePath.initialize(this.typeAttributeFeaturePath);
        }
        catch (CASException e) {
            this.featurePath = null;
            throw new IOException(e);
        }
        this.finalOffset = this.correctOffset(this.cas.getDocumentText().length());
        Type tokenType = this.cas.getTypeSystem().getType(this.tokenTypeString);
        this.iterator = this.cas.getAnnotationIndex(tokenType).iterator();
    }

    public boolean incrementToken() throws IOException {
        if (this.iterator == null) {
            this.initializeIterator();
        }
        if (this.iterator.hasNext()) {
            this.clearAttributes();
            AnnotationFS next = (AnnotationFS)this.iterator.next();
            this.termAttr.append(next.getCoveredText());
            this.offsetAttr.setOffset(this.correctOffset(next.getBegin()), this.correctOffset(next.getEnd()));
            this.typeAttr.setType(this.featurePath.getValueAsString((FeatureStructure)next));
            return true;
        }
        return false;
    }

    public void end() throws IOException {
        super.end();
        this.offsetAttr.setOffset(this.finalOffset, this.finalOffset);
    }
}

