/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima.ae;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.uima.ae.AEProvider;
import org.apache.lucene.analysis.uima.ae.BasicAEProvider;
import org.apache.lucene.analysis.uima.ae.OverridingParamsAEProvider;

public class AEProviderFactory {
    private static final AEProviderFactory instance = new AEProviderFactory();
    private final Map<String, AEProvider> providerCache = new HashMap<String, AEProvider>();

    private AEProviderFactory() {
    }

    public static AEProviderFactory getInstance() {
        return instance;
    }

    public synchronized AEProvider getAEProvider(String keyPrefix, String aePath, Map<String, Object> runtimeParameters) {
        String key = (keyPrefix != null ? keyPrefix : "") + aePath + (runtimeParameters != null ? runtimeParameters.toString() : "");
        if (this.providerCache.get(key) == null) {
            BasicAEProvider aeProvider = runtimeParameters != null ? new OverridingParamsAEProvider(aePath, runtimeParameters) : new BasicAEProvider(aePath);
            this.providerCache.put(key, aeProvider);
        }
        return this.providerCache.get(key);
    }

    public synchronized AEProvider getAEProvider(String aePath) {
        return this.getAEProvider(null, aePath, null);
    }

    public synchronized AEProvider getAEProvider(String aePath, Map<String, Object> runtimeParameters) {
        return this.getAEProvider(null, aePath, runtimeParameters);
    }
}

