/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.uima.ae.AEProviderFactory;
import org.apache.lucene.util.AttributeSource;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class BaseUIMATokenizer
extends Tokenizer {
    protected FSIterator<AnnotationFS> iterator;
    private final String descriptorPath;
    private final Map<String, Object> configurationParameters;
    protected AnalysisEngine ae;
    protected CAS cas;

    protected BaseUIMATokenizer(AttributeSource.AttributeFactory factory, Reader reader, String descriptorPath, Map<String, Object> configurationParameters) {
        super(factory, reader);
        this.descriptorPath = descriptorPath;
        this.configurationParameters = configurationParameters;
    }

    protected void analyzeInput() throws ResourceInitializationException, AnalysisEngineProcessException, IOException {
        if (this.ae == null) {
            this.ae = AEProviderFactory.getInstance().getAEProvider(null, this.descriptorPath, this.configurationParameters).getAE();
        }
        if (this.cas == null) {
            this.cas = this.ae.newCAS();
        } else {
            this.cas.reset();
        }
        this.cas.setDocumentText(this.toString(this.input));
        this.ae.process(this.cas);
    }

    protected abstract void initializeIterator() throws IOException;

    private String toString(Reader reader) throws IOException {
        int ch;
        StringBuilder stringBuilder = new StringBuilder();
        while ((ch = reader.read()) > -1) {
            stringBuilder.append((char)ch);
        }
        return stringBuilder.toString();
    }

    public void reset() throws IOException {
        this.iterator = null;
    }

    public void end() throws IOException {
        this.iterator = null;
    }
}

